/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.timeout;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotWrite;

public class AvoidForLoopCounterFilter
implements MutationInterceptor {
    private static final boolean DEBUG = false;
    private static final Match<AbstractInsnNode> IGNORE = InstructionMatchers.notAnInstruction().or(OpcodeMatchers.GETFIELD);
    private static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    static final SequenceMatcher<AbstractInsnNode> MUTATED_FOR_COUNTER = AvoidForLoopCounterFilter.conditionalAtEnd().or(AvoidForLoopCounterFilter.conditionalAtStart()).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(IGNORE).withDebug(false));
    private ClassTree currentClass;
    private Map<MethodTree, Set<AbstractInsnNode>> cache;

    private static SequenceQuery<AbstractInsnNode> conditionalAtEnd() {
        Slot<Integer> counterVariable = Slot.create(Integer.class);
        Slot<LabelNode> loopStart = Slot.create(LabelNode.class);
        Slot<LabelNode> loopEnd = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.anIStore(counterVariable.write()).and(InstructionMatchers.debug("end_counter"))).then(InstructionMatchers.isA(LabelNode.class).and(InstructionMatchers.debug("label 1"))).then(InstructionMatchers.gotoLabel(loopEnd.write()).and(InstructionMatchers.debug("goto"))).then(InstructionMatchers.aLabelNode(loopStart.write()).and(InstructionMatchers.debug("loop start"))).zeroOrMore(AvoidForLoopCounterFilter.anything()).then(AvoidForLoopCounterFilter.targetInstruction(counterVariable).and(InstructionMatchers.debug("target"))).then(InstructionMatchers.labelNode(loopEnd.read()).and(InstructionMatchers.debug("loop end"))).then(InstructionMatchers.anILoadOf(counterVariable.read()).and(InstructionMatchers.debug("read"))).zeroOrMore(AvoidForLoopCounterFilter.anything()).then(AvoidForLoopCounterFilter.loadsAnIntegerToCompareTo()).then(InstructionMatchers.aConditionalJumpTo(loopStart).and(InstructionMatchers.debug("jump"))).zeroOrMore(AvoidForLoopCounterFilter.anything());
    }

    private static SequenceQuery<AbstractInsnNode> conditionalAtStart() {
        Slot<Integer> counterVariable = Slot.create(Integer.class);
        Slot<LabelNode> loopStart = Slot.create(LabelNode.class);
        Slot<LabelNode> loopEnd = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.aLabelNode(loopStart.write()).and(InstructionMatchers.debug("conditional at start label"))).then(InstructionMatchers.anILoad(counterVariable.write()).and(InstructionMatchers.debug("iload"))).zeroOrMore(AvoidForLoopCounterFilter.anything()).then(InstructionMatchers.jumpsTo(loopEnd.write()).and(InstructionMatchers.aConditionalJump()).and(InstructionMatchers.debug("jump"))).then(InstructionMatchers.isA(LabelNode.class)).zeroOrMore(AvoidForLoopCounterFilter.anything()).then(AvoidForLoopCounterFilter.targetInstruction(counterVariable).and(InstructionMatchers.debug("target"))).then(InstructionMatchers.jumpsTo(loopStart.read()).and(InstructionMatchers.debug("jump"))).then(InstructionMatchers.labelNode(loopEnd.read())).zeroOrMore(AvoidForLoopCounterFilter.anything());
    }

    private static Match<AbstractInsnNode> loadsAnIntegerToCompareTo() {
        return OpcodeMatchers.BIPUSH.or(AvoidForLoopCounterFilter.integerMethodCall()).or(OpcodeMatchers.ARRAYLENGTH).or(InstructionMatchers.anIntegerConstant());
    }

    private static SequenceQuery<AbstractInsnNode> anything() {
        return QueryStart.match(InstructionMatchers.anyInstruction());
    }

    private static Match<AbstractInsnNode> integerMethodCall() {
        return InstructionMatchers.isA(MethodInsnNode.class);
    }

    private static Match<AbstractInsnNode> targetInstruction(Slot<Integer> counterVariable) {
        return InstructionMatchers.incrementsVariable(counterVariable.read()).and(AvoidForLoopCounterFilter.recordInstruction(MUTATED_INSTRUCTION.write()));
    }

    private static Match<AbstractInsnNode> recordInstruction(SlotWrite<AbstractInsnNode> slot) {
        return (c, t) -> Result.result(true, c.store(slot, t));
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
        this.cache = new IdentityHashMap<MethodTree, Set<AbstractInsnNode>>();
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return mutations.stream().filter(this.mutatesAForLoopCounter().negate()).collect(Collectors.toList());
    }

    private Predicate<MutationDetails> mutatesAForLoopCounter() {
        return a -> {
            int instruction = a.getInstructionIndex();
            Optional<MethodTree> maybeMethod = this.currentClass.method(a.getId().getLocation());
            if (maybeMethod.isEmpty()) {
                return false;
            }
            MethodTree method = maybeMethod.get();
            AbstractInsnNode mutatedInstruction = method.instruction(instruction);
            if (!(mutatedInstruction instanceof IincInsnNode)) {
                return false;
            }
            Set loopIncrements = this.cache.computeIfAbsent(method, this::findLoopCounters);
            return loopIncrements.contains(mutatedInstruction);
        };
    }

    private Set<AbstractInsnNode> findLoopCounters(MethodTree method) {
        Context context = Context.start(false);
        return MUTATED_FOR_COUNTER.contextMatches(method.instructions(), context).stream().map(c -> c.retrieve(MUTATED_INSTRUCTION.read())).flatMap(Optional::stream).collect(Collectors.toSet());
    }

    @Override
    public void end() {
        this.currentClass = null;
        this.cache = null;
    }
}

