/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.coverage.ClassLines;
import org.pitest.coverage.ReportCoverage;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.report.html.InputStreamLineIterable;
import org.pitest.mutationtest.report.html.Line;
import org.pitest.mutationtest.report.html.LineStatus;
import org.pitest.util.StringUtil;

public class AnnotatedLineFactory {
    private final Collection<MutationResult> mutations;
    private final ReportCoverage coverage;
    private final Collection<ClassLines> classesInFile;
    private final Set<Integer> coveredLines;

    public AnnotatedLineFactory(Collection<MutationResult> mutations, ReportCoverage coverage, Collection<ClassLines> classes) {
        this.mutations = mutations;
        this.coverage = coverage;
        this.classesInFile = classes;
        this.coveredLines = this.findCoveredLines(classes, coverage);
    }

    private Set<Integer> findCoveredLines(Collection<ClassLines> classes, ReportCoverage coverage) {
        return classes.stream().flatMap(cl -> coverage.getCoveredLines(cl.name()).stream().map(l -> l.getLineNumber())).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Line> convert(Reader source) throws IOException {
        try {
            InputStreamLineIterable lines = new InputStreamLineIterable(source);
            List list = FCollection.map((Iterable)lines, this.stringToAnnotatedLine());
            return list;
        }
        finally {
            source.close();
        }
    }

    private Function<String, Line> stringToAnnotatedLine() {
        return new Function<String, Line>(){
            private int lineNumber = 1;

            @Override
            public Line apply(String a) {
                Line l = new Line(this.lineNumber, StringUtil.escapeBasicHtmlChars((String)a), AnnotatedLineFactory.this.lineCovered(this.lineNumber), AnnotatedLineFactory.this.getMutationsForLine(this.lineNumber));
                ++this.lineNumber;
                return l;
            }
        };
    }

    private List<MutationResult> getMutationsForLine(int lineNumber) {
        return this.mutations.stream().filter(this.isAtLineNumber(lineNumber)).collect(Collectors.toList());
    }

    private Predicate<MutationResult> isAtLineNumber(int lineNumber) {
        return result -> result.getDetails().getLineNumber() == lineNumber;
    }

    private LineStatus lineCovered(int line) {
        if (!this.isCodeLine(line)) {
            return LineStatus.NotApplicable;
        }
        if (this.isLineCovered(line)) {
            return LineStatus.Covered;
        }
        return LineStatus.NotCovered;
    }

    private boolean isCodeLine(int line) {
        return FCollection.contains(this.classesInFile, a -> a.isCodeLine(line));
    }

    private boolean isLineCovered(int line) {
        return this.coveredLines.contains(line);
    }
}

