/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.util.Glob;

public class SurefireConfigConverter {
    public ReportOptions update(ReportOptions option, Xpp3Dom configuration) {
        if (configuration == null) {
            return option;
        }
        this.convertExcludes(option, configuration);
        this.convertGroups(option, configuration);
        this.convertTestFailureIgnore(option, configuration);
        return option;
    }

    private void convertGroups(ReportOptions option, Xpp3Dom configuration) {
        TestGroupConfig existing = option.getGroupConfig();
        if (existing == null || existing.getExcludedGroups().isEmpty() && existing.getIncludedGroups().isEmpty()) {
            List<String> groups = this.extractStrings("groups", configuration);
            List<String> excluded = this.extractStrings("excludedGroups", configuration);
            TestGroupConfig gc = new TestGroupConfig(excluded, groups);
            option.setGroupConfig(gc);
        }
    }

    private List<String> extractStrings(String element, Xpp3Dom configuration) {
        Xpp3Dom groups = configuration.getChild(element);
        if (groups != null) {
            String[] parts = groups.getValue().split(" ");
            return Arrays.asList(parts);
        }
        return Collections.emptyList();
    }

    private void convertExcludes(ReportOptions option, Xpp3Dom configuration) {
        List excludes = FCollection.map(this.extract("excludes", configuration), this.filenameToClassFilter());
        excludes.addAll(option.getExcludedTestClasses());
        option.setExcludedTestClasses((Collection)excludes);
    }

    private Function<String, Predicate<String>> filenameToClassFilter() {
        return new Function<String, Predicate<String>>(){

            @Override
            public Predicate<String> apply(String a) {
                return new Glob(a.replace(".java", "").replace("/", "."));
            }
        };
    }

    private List<String> extract(String childname, Xpp3Dom config) {
        Xpp3Dom subelement = config.getChild(childname);
        if (subelement != null) {
            Xpp3Dom[] children;
            LinkedList<String> result = new LinkedList<String>();
            for (Xpp3Dom child : children = subelement.getChildren()) {
                result.add(child.getValue());
            }
            return result;
        }
        return Collections.emptyList();
    }

    private void convertTestFailureIgnore(ReportOptions option, Xpp3Dom configuration) {
        Xpp3Dom testFailureIgnore = configuration.getChild("testFailureIgnore");
        if (testFailureIgnore != null) {
            option.setSkipFailingTests(Boolean.parseBoolean(testFailureIgnore.getValue()));
        }
    }
}

