/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.api.RefCursor;
import io.r2dbc.postgresql.codec.Box;
import io.r2dbc.postgresql.codec.Circle;
import io.r2dbc.postgresql.codec.Interval;
import io.r2dbc.postgresql.codec.Json;
import io.r2dbc.postgresql.codec.Line;
import io.r2dbc.postgresql.codec.Lseg;
import io.r2dbc.postgresql.codec.Path;
import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.codec.Polygon;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.R2dbcType;
import io.r2dbc.spi.Type;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.UUID;
import reactor.util.annotation.Nullable;

public enum PostgresqlObjectId implements Type,
PostgresTypeIdentifier
{
    BIT(1560),
    BIT_ARRAY(1561),
    BOOL(16, Boolean.class),
    BOOL_ARRAY(1000, Boolean[].class),
    BOX(603, Box.class),
    BOX_ARRAY(1020, Box[].class),
    BPCHAR(1042, String.class),
    BPCHAR_ARRAY(1014, String[].class),
    BYTEA(17, ByteBuffer.class),
    BYTEA_ARRAY(1001, ByteBuffer[].class),
    CHAR(18, Character.class),
    CHAR_ARRAY(1002, Character[].class),
    CIRCLE(718, Circle.class),
    CIRCLE_ARRAY(719, Circle[].class),
    DATE(1082, LocalDate.class),
    DATE_ARRAY(1182, LocalDate[].class),
    FLOAT4(700, Float.class),
    FLOAT4_ARRAY(1021, Float[].class),
    FLOAT8(701, Double.class),
    FLOAT8_ARRAY(1022, Double[].class),
    INET(869, InetAddress.class),
    INET_ARRAY(1041, InetAddress[].class),
    INT2(21, Short.class),
    INT2_ARRAY(1005, Short[].class),
    INT4(23, Integer.class),
    INT4_ARRAY(1007, Integer[].class),
    INT8(20, Long.class),
    INT8_ARRAY(1016, Long[].class),
    INTERVAL(1186, Interval.class),
    INTERVAL_ARRAY(1187, Interval[].class),
    JSON(114, Json.class),
    JSON_ARRAY(199, Json[].class),
    JSONB(3802, Json.class),
    JSONB_ARRAY(3807, Json.class),
    LINE(628, Line.class),
    LINE_ARRAY(629, Line[].class),
    LSEG(601, Lseg.class),
    LSEG_ARRAY(1018, Lseg[].class),
    MONEY(790),
    MONEY_ARRAY(791),
    NAME(19, String.class),
    NAME_ARRAY(1003, String[].class),
    NUMERIC(1700, BigDecimal.class),
    NUMERIC_ARRAY(1231, BigDecimal[].class),
    OID(26, Integer.class),
    OID_ARRAY(1028, Integer[].class),
    PATH(602, Path.class),
    PATH_ARRAY(1019, Path[].class),
    POINT(600, Point.class),
    POINT_ARRAY(1017, Point[].class),
    POLYGON(604, Polygon.class),
    POLYGON_ARRAY(1027, Polygon[].class),
    REF_CURSOR(1790, RefCursor.class),
    REF_CURSOR_ARRAY(2201, RefCursor[].class),
    TEXT(25, Clob.class),
    TEXT_ARRAY(1009, Clob[].class),
    TIME(1083, LocalTime.class),
    TIME_ARRAY(1183, LocalTime[].class),
    TIMESTAMP(1114, LocalDateTime.class),
    TIMESTAMP_ARRAY(1115, LocalDateTime[].class),
    TIMESTAMPTZ(1184, OffsetDateTime.class),
    TIMESTAMPTZ_ARRAY(1185, OffsetDateTime[].class),
    TIMETZ(1266, OffsetTime.class),
    TIMETZ_ARRAY(1270, OffsetTime[].class),
    UNKNOWN(705),
    UNSPECIFIED(0),
    UUID(2950, UUID.class),
    UUID_ARRAY(2951, UUID[].class),
    VARBIT(1562),
    VARBIT_ARRAY(1563),
    VARCHAR(1043, String.class),
    VARCHAR_ARRAY(1015, String[].class),
    VOID(2278, Void.class),
    XML(142),
    XML_ARRAY(143);

    public static final int OID_CACHE_SIZE = 3810;
    private static final PostgresqlObjectId[] CACHE;
    private final int objectId;
    private final Class<?> defaultJavaType;

    private PostgresqlObjectId(int objectId) {
        this(objectId, Object.class);
    }

    private PostgresqlObjectId(int objectId, Class<?> defaultJavaType) {
        this.objectId = objectId;
        this.defaultJavaType = Assert.requireNonNull(defaultJavaType, "defaultJavaType must not be null");
    }

    public static PostgresqlObjectId from(PostgresTypeIdentifier dataType) {
        if (dataType instanceof PostgresqlObjectId) {
            return (PostgresqlObjectId)dataType;
        }
        return PostgresqlObjectId.valueOf(dataType.getObjectId());
    }

    public static boolean isValid(int objectId) {
        if (objectId >= 0 && objectId < 3810) {
            PostgresqlObjectId oid = CACHE[objectId];
            return oid != null;
        }
        return false;
    }

    public static PostgresqlObjectId valueOf(int objectId) {
        PostgresqlObjectId oid = null;
        if (objectId >= 0 && objectId < 3810) {
            oid = CACHE[objectId];
        }
        if (oid == null) {
            throw new IllegalArgumentException(String.format("%d is not a valid object id", objectId));
        }
        return oid;
    }

    public static PostgresqlObjectId valueOf(R2dbcType type) {
        Assert.requireNonNull(type, "type must not be null");
        switch (type) {
            case NCHAR: 
            case CHAR: {
                return CHAR;
            }
            case NVARCHAR: 
            case VARCHAR: {
                return VARCHAR;
            }
            case CLOB: 
            case NCLOB: {
                return TEXT;
            }
            case BOOLEAN: {
                return BOOL;
            }
            case BINARY: 
            case VARBINARY: 
            case BLOB: {
                return BYTEA;
            }
            case INTEGER: {
                return INT4;
            }
            case TINYINT: {
                return BIT;
            }
            case SMALLINT: {
                return INT2;
            }
            case BIGINT: {
                return INT8;
            }
            case NUMERIC: 
            case DECIMAL: {
                return NUMERIC;
            }
            case FLOAT: 
            case REAL: {
                return FLOAT4;
            }
            case DOUBLE: {
                return FLOAT8;
            }
            case DATE: {
                return DATE;
            }
            case TIME: {
                return TIME;
            }
            case TIME_WITH_TIME_ZONE: {
                return TIMETZ;
            }
            case TIMESTAMP: {
                return TIMESTAMP;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return TIMESTAMPTZ;
            }
            case COLLECTION: {
                throw new UnsupportedOperationException("Raw collection (without component type) is not supported");
            }
        }
        throw new UnsupportedOperationException("Type " + type + " not supported");
    }

    public Class<?> getJavaType() {
        return this.defaultJavaType;
    }

    public String getName() {
        return this.name();
    }

    @Override
    public int getObjectId() {
        return this.objectId;
    }

    public static int toInt(@Nullable Long oid) {
        Assert.requireNonNull(oid, "OID must not be null");
        return PostgresqlObjectId.toInt((long)oid);
    }

    public static int toInt(long oid) {
        if ((oid & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("Value is not an OID:" + oid);
        }
        return (int)oid;
    }

    public static long toLong(int oid) {
        return Integer.toUnsignedLong(oid);
    }

    static {
        CACHE = new PostgresqlObjectId[3810];
        PostgresqlObjectId[] postgresqlObjectIdArray = PostgresqlObjectId.values();
        int n = postgresqlObjectIdArray.length;
        for (int i = 0; i < n; ++i) {
            PostgresqlObjectId oid;
            PostgresqlObjectId.CACHE[oid.getObjectId()] = oid = postgresqlObjectIdArray[i];
        }
    }
}

