/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.IntegerCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Function;

class IntegerCodecDelegate<T>
extends AbstractCodec<T> {
    private final IntegerCodec delegate;
    private final Function<T, Integer> toIntegerConverter;
    private final Function<Integer, T> fromIntegerConverter;

    IntegerCodecDelegate(Class<T> type, ByteBufAllocator byteBufAllocator, Function<T, Integer> toIntegerConverter, Function<Integer, T> fromIntegerConverter) {
        super(type);
        this.delegate = new IntegerCodec(byteBufAllocator);
        this.toIntegerConverter = toIntegerConverter;
        this.fromIntegerConverter = fromIntegerConverter;
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        return this.delegate.doCanDecode(type, format);
    }

    @Override
    T doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, Format format, Class<? extends T> type) {
        Object number = this.delegate.doDecode(buffer, dataType, format, Integer.TYPE);
        return this.fromIntegerConverter.apply((Integer)number);
    }

    @Override
    EncodedParameter doEncode(T value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(this.toIntegerConverter.apply(value));
    }

    @Override
    EncodedParameter doEncode(T value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        Assert.requireNonNull(dataType, "dataType must not be null");
        return this.delegate.doEncode(this.toIntegerConverter.apply(value), dataType);
    }

    @Override
    public Iterable<PostgresTypeIdentifier> getDataTypes() {
        return this.delegate.getDataTypes();
    }

    @Override
    public EncodedParameter encodeNull() {
        return this.delegate.encodeNull();
    }
}

