/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

public final class Point {
    private final double x;
    private final double y;

    private Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static Point of(double x, double y) {
        return new Point(x, y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Point translate(int x, int y) {
        return this.translate((double)x, (double)y);
    }

    public Point translate(double x, double y) {
        return new Point(this.x + x, this.y + y);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point) {
            Point p = (Point)obj;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    public int hashCode() {
        long v1 = Double.doubleToLongBits(this.x);
        long v2 = Double.doubleToLongBits(this.y);
        return (int)(v1 ^ v2 ^ v1 >>> 32 ^ v2 >>> 32);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

