/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.api.ErrorDetails;
import io.r2dbc.postgresql.api.PostgresqlException;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.ErrorResponse;
import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcRollbackException;
import io.r2dbc.spi.R2dbcTransientException;
import reactor.core.publisher.SynchronousSink;
import reactor.util.annotation.Nullable;

final class ExceptionFactory {
    public static final ExceptionFactory INSTANCE = new ExceptionFactory("");
    private final String sql;

    private ExceptionFactory(String sql) {
        this.sql = sql;
    }

    static ExceptionFactory withSql(String sql) {
        return new ExceptionFactory(sql);
    }

    static R2dbcException createException(ErrorResponse response, String sql) {
        return ExceptionFactory.createException(new ErrorDetails(response.getFields()), sql);
    }

    private static R2dbcException createException(ErrorDetails errorDetails, String sql) {
        String codeClass;
        switch (errorDetails.getCode()) {
            case "42501": {
                return new PostgresqlPermissionDeniedException(errorDetails, sql);
            }
            case "40000": 
            case "40001": {
                return new PostgresqlRollbackException(errorDetails, sql);
            }
            case "28000": 
            case "28P01": {
                return new PostgresqlAuthenticationFailure(errorDetails, sql);
            }
        }
        switch (codeClass = errorDetails.getCode().length() > 2 ? errorDetails.getCode().substring(0, 2) : "99") {
            case "03": 
            case "42": 
            case "22": 
            case "26": {
                return new PostgresqlBadGrammarException(errorDetails, sql);
            }
            case "08": {
                return new PostgresqlNonTransientResourceException(errorDetails, sql);
            }
            case "21": 
            case "23": 
            case "27": {
                return new PostgresqlDataIntegrityViolationException(errorDetails, sql);
            }
            case "28": {
                return new PostgresqlPermissionDeniedException(errorDetails, sql);
            }
            case "40": {
                return new PostgresqlTransientException(errorDetails, sql);
            }
        }
        return new PostgresqlNonTransientResourceException(errorDetails, sql);
    }

    public R2dbcException createException(ErrorDetails errorDetails) {
        return ExceptionFactory.createException(errorDetails, this.sql);
    }

    void handleErrorResponse(BackendMessage message, SynchronousSink<BackendMessage> sink) {
        if (message instanceof ErrorResponse) {
            sink.error((Throwable)ExceptionFactory.createException((ErrorResponse)message, this.sql));
        } else {
            sink.next((Object)message);
        }
    }

    static final class PostgresqlPermissionDeniedException
    extends R2dbcPermissionDeniedException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlPermissionDeniedException(ErrorDetails errorDetails, @Nullable String sql) {
            super(errorDetails.getMessage(), errorDetails.getCode(), 0, sql);
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlRollbackException
    extends R2dbcRollbackException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlRollbackException(ErrorDetails errorDetails, @Nullable String sql) {
            super(errorDetails.getMessage(), errorDetails.getCode(), 0, sql);
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlAuthenticationFailure
    extends R2dbcPermissionDeniedException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlAuthenticationFailure(ErrorDetails errorDetails, @Nullable String sql) {
            super(errorDetails.getMessage(), errorDetails.getCode(), 0, sql);
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlBadGrammarException
    extends R2dbcBadGrammarException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlBadGrammarException(ErrorDetails errorDetails, String sql) {
            super(errorDetails.getMessage(), errorDetails.getCode(), 0, sql);
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlNonTransientResourceException
    extends R2dbcNonTransientResourceException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlNonTransientResourceException(ErrorDetails errorDetails, @Nullable String sql) {
            super(errorDetails.getMessage(), errorDetails.getCode(), 0, sql);
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlDataIntegrityViolationException
    extends R2dbcDataIntegrityViolationException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlDataIntegrityViolationException(ErrorDetails errorDetails, @Nullable String sql) {
            super(errorDetails.getMessage(), errorDetails.getCode(), 0, sql);
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class PostgresqlTransientException
    extends R2dbcTransientException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlTransientException(ErrorDetails errorDetails, @Nullable String sql) {
            super(errorDetails.getMessage(), errorDetails.getCode(), 0, sql);
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }
}

