/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.AuthenticationCleartextPassword;
import io.r2dbc.postgresql.message.backend.AuthenticationGSS;
import io.r2dbc.postgresql.message.backend.AuthenticationGSSContinue;
import io.r2dbc.postgresql.message.backend.AuthenticationKerberosV5;
import io.r2dbc.postgresql.message.backend.AuthenticationMD5Password;
import io.r2dbc.postgresql.message.backend.AuthenticationOk;
import io.r2dbc.postgresql.message.backend.AuthenticationSASL;
import io.r2dbc.postgresql.message.backend.AuthenticationSASLContinue;
import io.r2dbc.postgresql.message.backend.AuthenticationSASLFinal;
import io.r2dbc.postgresql.message.backend.AuthenticationSCMCredential;
import io.r2dbc.postgresql.message.backend.AuthenticationSSPI;
import io.r2dbc.postgresql.message.backend.BackendKeyData;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.BindComplete;
import io.r2dbc.postgresql.message.backend.CloseComplete;
import io.r2dbc.postgresql.message.backend.CommandComplete;
import io.r2dbc.postgresql.message.backend.CopyBothResponse;
import io.r2dbc.postgresql.message.backend.CopyData;
import io.r2dbc.postgresql.message.backend.CopyDone;
import io.r2dbc.postgresql.message.backend.CopyInResponse;
import io.r2dbc.postgresql.message.backend.CopyOutResponse;
import io.r2dbc.postgresql.message.backend.DataRow;
import io.r2dbc.postgresql.message.backend.EmptyQueryResponse;
import io.r2dbc.postgresql.message.backend.ErrorResponse;
import io.r2dbc.postgresql.message.backend.FunctionCallResponse;
import io.r2dbc.postgresql.message.backend.NoData;
import io.r2dbc.postgresql.message.backend.NoticeResponse;
import io.r2dbc.postgresql.message.backend.NotificationResponse;
import io.r2dbc.postgresql.message.backend.ParameterDescription;
import io.r2dbc.postgresql.message.backend.ParameterStatus;
import io.r2dbc.postgresql.message.backend.ParseComplete;
import io.r2dbc.postgresql.message.backend.PortalSuspended;
import io.r2dbc.postgresql.message.backend.ReadyForQuery;
import io.r2dbc.postgresql.message.backend.RowDescription;
import io.r2dbc.postgresql.util.Assert;

public final class BackendMessageDecoder {
    public static BackendMessage decode(ByteBuf envelope) {
        Assert.requireNonNull(envelope, "in must not be null");
        MessageType messageType = MessageType.valueOf(envelope.readByte());
        envelope.skipBytes(4);
        return BackendMessageDecoder.decodeBody(envelope, messageType);
    }

    private static BackendMessage decodeBody(ByteBuf body, MessageType messageType) {
        switch (messageType.ordinal()) {
            case 0: {
                return BackendMessageDecoder.decodeAuthentication(body);
            }
            case 1: {
                return BackendKeyData.decode(body);
            }
            case 2: {
                return BindComplete.INSTANCE;
            }
            case 3: {
                return CloseComplete.INSTANCE;
            }
            case 4: {
                return CommandComplete.decode(body);
            }
            case 6: {
                return CopyData.decode(body);
            }
            case 7: {
                return CopyDone.INSTANCE;
            }
            case 5: {
                return CopyBothResponse.decode(body);
            }
            case 8: {
                return CopyInResponse.decode(body);
            }
            case 9: {
                return CopyOutResponse.decode(body);
            }
            case 10: {
                return DataRow.decode(body);
            }
            case 11: {
                return EmptyQueryResponse.INSTANCE;
            }
            case 12: {
                return ErrorResponse.decode(body);
            }
            case 13: {
                return FunctionCallResponse.decode(body);
            }
            case 14: {
                return NoData.INSTANCE;
            }
            case 15: {
                return NoticeResponse.decode(body);
            }
            case 16: {
                return NotificationResponse.decode(body);
            }
            case 17: {
                return ParameterDescription.decode(body);
            }
            case 18: {
                return ParameterStatus.decode(body);
            }
            case 19: {
                return ParseComplete.INSTANCE;
            }
            case 20: {
                return PortalSuspended.INSTANCE;
            }
            case 21: {
                return ReadyForQuery.decode(body);
            }
            case 22: {
                return RowDescription.decode(body);
            }
        }
        throw new IllegalArgumentException(String.format("%s is not a supported message type", new Object[]{messageType}));
    }

    private static BackendMessage decodeAuthentication(ByteBuf in) {
        AuthenticationType authenticationType = AuthenticationType.valueOf(in.readInt());
        switch (authenticationType.ordinal()) {
            case 0: {
                return AuthenticationOk.INSTANCE;
            }
            case 1: {
                return AuthenticationKerberosV5.INSTANCE;
            }
            case 2: {
                return AuthenticationCleartextPassword.INSTANCE;
            }
            case 3: {
                return AuthenticationGSS.INSTANCE;
            }
            case 4: {
                return AuthenticationGSSContinue.decode(in);
            }
            case 5: {
                return AuthenticationMD5Password.decode(in);
            }
            case 6: {
                return AuthenticationSCMCredential.INSTANCE;
            }
            case 7: {
                return AuthenticationSASL.decode(in);
            }
            case 8: {
                return AuthenticationSASLContinue.decode(in);
            }
            case 9: {
                return AuthenticationSASLFinal.decode(in);
            }
            case 10: {
                return AuthenticationSSPI.INSTANCE;
            }
        }
        throw new IllegalArgumentException(String.format("%s is not a supported authentication type", new Object[]{authenticationType}));
    }

    private static enum MessageType {
        AUTHENTICATION('R'),
        BACKEND_KEY_DATA('K'),
        BIND_COMPLETE('2'),
        CLOSE_COMPLETE('3'),
        COMMAND_COMPLETE('C'),
        COPY_BOTH_RESPONSE('W'),
        COPY_DATA('d'),
        COPY_DONE('c'),
        COPY_IN_RESPONSE('G'),
        COPY_OUT_RESPONSE('H'),
        DATA_ROW('D'),
        EMPTY_QUERY_RESPONSE('I'),
        ERROR_RESPONSE('E'),
        FUNCTION_CALL_RESPONSE('V'),
        NO_DATA('n'),
        NOTICE_RESPONSE('N'),
        NOTIFICATION_RESPONSE('A'),
        PARAMETER_DESCRIPTION('t'),
        PARAMETER_STATUS('S'),
        PARSE_COMPLETE('1'),
        PORTAL_SUSPENDED('s'),
        READY_FOR_QUERY('Z'),
        ROW_DESCRIPTION('T');

        private static final MessageType[] CACHE;
        private final char discriminator;

        private MessageType(char discriminator) {
            this.discriminator = discriminator;
        }

        static MessageType valueOf(byte b) {
            MessageType messageType = CACHE[Math.abs(-128) + b];
            if (messageType == null) {
                throw new IllegalArgumentException(String.format("%c is not a valid message type", b));
            }
            return messageType;
        }

        static {
            CACHE = new MessageType[Math.abs(-128) + 127];
            MessageType[] messageTypeArray = MessageType.values();
            int n = messageTypeArray.length;
            for (int i = 0; i < n; ++i) {
                MessageType messageType;
                MessageType.CACHE[Math.abs((int)-128) + (byte)messageType.discriminator] = messageType = messageTypeArray[i];
            }
        }
    }

    private static enum AuthenticationType {
        OK(0),
        KERBEROS_V5(2),
        CLEARTEXT_PASSWORD(3),
        GSS(7),
        GSS_CONTINUE(8),
        MD5_PASSWORD(5),
        SCMC_CREDENTIAL(6),
        SASL(10),
        SASL_CONTINUE(11),
        SASL_FINAL(12),
        SSPI(9);

        private final int discriminator;

        private AuthenticationType(int discriminator) {
            this.discriminator = discriminator;
        }

        static AuthenticationType valueOf(int i) {
            for (AuthenticationType authType : AuthenticationType.values()) {
                if (authType.discriminator != i) continue;
                return authType;
            }
            throw new IllegalArgumentException(String.format("%d is not a valid authentication type", i));
        }
    }
}

