/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import io.r2dbc.spi.Clob;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ClobCodec
extends AbstractCodec<Clob> {
    private final ByteBufAllocator byteBufAllocator;

    ClobCodec(ByteBufAllocator byteBufAllocator) {
        super(Clob.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public EncodedParameter encodeNull() {
        return ClobCodec.createNull(Format.FORMAT_TEXT, PostgresqlObjectId.TEXT);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.TEXT == type;
    }

    @Override
    Clob doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, @Nullable Class<? extends Clob> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return Clob.from((Publisher)Mono.just((Object)ByteBufUtils.decode(buffer)));
    }

    @Override
    EncodedParameter doEncode(Clob value) {
        return this.doEncode(value, (PostgresTypeIdentifier)PostgresqlObjectId.VARCHAR);
    }

    @Override
    EncodedParameter doEncode(Clob value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return ClobCodec.create(Format.FORMAT_TEXT, dataType, (Publisher<? extends ByteBuf>)Flux.from((Publisher)value.stream()).reduce((Object)new StringBuilder(), StringBuilder::append).map(sb -> ByteBufUtils.encode(this.byteBufAllocator, sb.toString())).concatWith((Publisher)Flux.from((Publisher)value.discard()).then(Mono.empty())));
    }

    public Iterable<PostgresTypeIdentifier> getDataTypes() {
        return Arrays.asList(PostgresqlObjectId.VARCHAR, PostgresqlObjectId.TEXT);
    }
}

