/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.classloader.annotations.MockPolicy;
import org.powermock.core.classloader.annotations.PowerMockListener;
import org.powermock.core.classloader.annotations.PrepareEverythingForTest;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.PrepareOnlyThisForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.core.classloader.annotations.UseClassPathAdjuster;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.core.transformers.impl.MainMockTransformer;
import org.powermock.core.transformers.impl.TestClassTransformer;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.proxyframework.RegisterProxyFramework;
import org.powermock.tests.utils.ArrayMerger;
import org.powermock.tests.utils.IgnorePackagesExtractor;
import org.powermock.tests.utils.TestChunk;
import org.powermock.tests.utils.TestClassesExtractor;
import org.powermock.tests.utils.TestSuiteChunker;
import org.powermock.tests.utils.impl.ArrayMergerImpl;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;
import org.powermock.tests.utils.impl.PowerMockIgnorePackagesExtractorImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;
import org.powermock.tests.utils.impl.TestCaseEntry;
import org.powermock.tests.utils.impl.TestChunkImpl;

public abstract class AbstractTestSuiteChunkerImpl<T>
implements TestSuiteChunker {
    private static final int DEFAULT_TEST_LISTENERS_SIZE = 1;
    protected static final int NOT_INITIALIZED = -1;
    private static final int INTERNAL_INDEX_NOT_FOUND = -1;
    protected final TestClassesExtractor prepareForTestExtractor = new PrepareForTestExtractorImpl();
    protected final TestClassesExtractor suppressionExtractor = new StaticConstructorSuppressExtractorImpl();
    private final IgnorePackagesExtractor ignorePackagesExtractor = new PowerMockIgnorePackagesExtractorImpl();
    private final ArrayMerger arrayMerger = new ArrayMergerImpl();
    private final Class<?>[] testClasses;
    protected final Set<Class<?>> delegatesCreatedForTheseClasses = new LinkedHashSet();
    protected final List<T> delegates = new ArrayList<T>();
    protected final LinkedHashMap<Integer, List<Integer>> testAtDelegateMapper = new LinkedHashMap();
    private int currentTestIndex = -1;
    private final List<TestCaseEntry> internalSuites;
    protected volatile int testCount = -1;

    protected AbstractTestSuiteChunkerImpl(Class<?> testClass) throws Exception {
        this(new Class[]{testClass});
    }

    protected AbstractTestSuiteChunkerImpl(Class<?> ... testClasses) throws Exception {
        this.testClasses = testClasses;
        this.internalSuites = new LinkedList<TestCaseEntry>();
        for (Class<?> clazz : testClasses) {
            this.chunkClass(clazz);
        }
    }

    protected Object getPowerMockTestListenersLoadedByASpecificClassLoader(Class<?> clazz, ClassLoader classLoader) {
        try {
            int defaultListenerSize = 1;
            Class<?> annotationEnablerClass = null;
            try {
                annotationEnablerClass = Class.forName("org.powermock.api.extension.listener.AnnotationEnabler", false, classLoader);
            }
            catch (ClassNotFoundException e) {
                defaultListenerSize = 0;
            }
            this.registerProxyframework(classLoader);
            Class<?> powerMockTestListenerType = Class.forName(PowerMockTestListener.class.getName(), false, classLoader);
            Object testListeners = null;
            if (clazz.isAnnotationPresent(PowerMockListener.class)) {
                PowerMockListener annotation = clazz.getAnnotation(PowerMockListener.class);
                Class<? extends PowerMockTestListener>[] powerMockTestListeners = annotation.value();
                if (powerMockTestListeners.length > 0) {
                    testListeners = Array.newInstance(powerMockTestListenerType, powerMockTestListeners.length + defaultListenerSize);
                    for (int i = 0; i < powerMockTestListeners.length; ++i) {
                        String testListenerClassName = powerMockTestListeners[i].getName();
                        Class<?> listenerTypeLoadedByClassLoader = Class.forName(testListenerClassName, false, classLoader);
                        Array.set(testListeners, i, Whitebox.newInstance(listenerTypeLoadedByClassLoader));
                    }
                }
            } else {
                testListeners = Array.newInstance(powerMockTestListenerType, defaultListenerSize);
            }
            if (annotationEnablerClass != null) {
                Array.set(testListeners, Array.getLength(testListeners) - 1, Whitebox.newInstance(annotationEnablerClass));
            }
            return testListeners;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("PowerMock internal error: Failed to load class.", e);
        }
    }

    private void registerProxyframework(ClassLoader classLoader) {
        Class<?> proxyFrameworkClass = null;
        try {
            proxyFrameworkClass = Class.forName("org.powermock.api.extension.proxyframework.ProxyFrameworkImpl", false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Extension API internal error: org.powermock.api.extension.proxyframework.ProxyFrameworkImpl could not be located in classpath.");
        }
        Class<?> proxyFrameworkRegistrar = null;
        try {
            proxyFrameworkRegistrar = Class.forName(RegisterProxyFramework.class.getName(), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            Whitebox.invokeMethod(proxyFrameworkRegistrar, (String)"registerProxyFramework", (Object[])new Object[]{Whitebox.newInstance(proxyFrameworkClass)});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void chunkClass(Class<?> testClass) throws Exception {
        ClassLoader defaultMockLoader = null;
        ArrayList<Method> testMethodsForOtherClassLoaders = new ArrayList<Method>();
        MockTransformer[] extraMockTransformers = this.createDefaultExtraMockTransformers(testClass, testMethodsForOtherClassLoaders);
        String[] ignorePackages = this.ignorePackagesExtractor.getPackagesToIgnore(testClass);
        if (testClass.isAnnotationPresent(PrepareEverythingForTest.class)) {
            defaultMockLoader = this.createNewClassloader(testClass, new String[]{"*"}, ignorePackages, extraMockTransformers);
        } else {
            String[] prepareForTestClasses = this.prepareForTestExtractor.getTestClasses(testClass);
            String[] suppressStaticClasses = this.suppressionExtractor.getTestClasses(testClass);
            defaultMockLoader = this.createNewClassloader(testClass, this.arrayMerger.mergeArrays(String.class, prepareForTestClasses, suppressStaticClasses), ignorePackages, extraMockTransformers);
        }
        this.registerProxyframework(defaultMockLoader);
        LinkedList<Method> currentClassloaderMethods = new LinkedList<Method>();
        TestChunkImpl defaultTestChunk = new TestChunkImpl(defaultMockLoader, currentClassloaderMethods);
        LinkedList<TestChunk> testChunks = new LinkedList<TestChunk>();
        testChunks.add(defaultTestChunk);
        this.internalSuites.add(new TestCaseEntry(testClass, testChunks));
        this.initEntries(this.internalSuites);
        if (!currentClassloaderMethods.isEmpty()) {
            List<TestChunk> allTestChunks = this.internalSuites.get(0).getTestChunks();
            for (TestChunk chunk : allTestChunks.subList(1, allTestChunks.size())) {
                for (Method m : chunk.getTestMethodsToBeExecutedByThisClassloader()) {
                    testMethodsForOtherClassLoaders.add(m);
                }
            }
        } else if (2 <= this.internalSuites.size() || 1 == this.internalSuites.size() && 2 <= this.internalSuites.get(0).getTestChunks().size()) {
            this.internalSuites.get(0).getTestChunks().remove(0);
        }
    }

    @Override
    public ClassLoader createNewClassloader(Class<?> testClass, String[] preliminaryClassesToLoadByMockClassloader, final String[] packagesToIgnore, MockTransformer ... extraMockTransformers) {
        ClassLoader mockLoader = null;
        final String[] classesToLoadByMockClassloader = this.makeSureArrayContainsTestClassName(preliminaryClassesToLoadByMockClassloader, testClass.getName());
        if (!(classesToLoadByMockClassloader != null && classesToLoadByMockClassloader.length != 0 || this.hasMockPolicyProvidedClasses(testClass))) {
            mockLoader = Thread.currentThread().getContextClassLoader();
        } else {
            ArrayList<MockTransformer> mockTransformerChain = new ArrayList<MockTransformer>();
            MainMockTransformer mainMockTransformer = new MainMockTransformer();
            mockTransformerChain.add(mainMockTransformer);
            Collections.addAll(mockTransformerChain, extraMockTransformers);
            final UseClassPathAdjuster useClassPathAdjuster = testClass.getAnnotation(UseClassPathAdjuster.class);
            mockLoader = AccessController.doPrivileged(new PrivilegedAction<MockClassLoader>(){

                @Override
                public MockClassLoader run() {
                    return new MockClassLoader(classesToLoadByMockClassloader, packagesToIgnore, useClassPathAdjuster);
                }
            });
            MockClassLoader mockClassLoader = (MockClassLoader)mockLoader;
            mockClassLoader.setMockTransformerChain(mockTransformerChain);
            new MockPolicyInitializerImpl(testClass).initialize(mockLoader);
        }
        return mockLoader;
    }

    @Override
    public void createTestDelegators(Class<?> testClass, List<TestChunk> chunks) throws Exception {
        for (TestChunk chunk : chunks) {
            ClassLoader classLoader = chunk.getClassLoader();
            List<Method> methodsToTest = chunk.getTestMethodsToBeExecutedByThisClassloader();
            T runnerDelegator = this.createDelegatorFromClassloader(classLoader, testClass, methodsToTest);
            this.delegates.add(runnerDelegator);
        }
        this.delegatesCreatedForTheseClasses.add(testClass);
    }

    private MockTransformer[] createDefaultExtraMockTransformers(Class<?> testClass, List<Method> testMethodsThatRunOnOtherClassLoaders) {
        if (null == this.testMethodAnnotation()) {
            return new MockTransformer[0];
        }
        return new MockTransformer[]{TestClassTransformer.forTestClass(testClass).removesTestMethodAnnotation(this.testMethodAnnotation()).fromMethods(testMethodsThatRunOnOtherClassLoaders)};
    }

    protected Class<? extends Annotation> testMethodAnnotation() {
        return null;
    }

    protected abstract T createDelegatorFromClassloader(ClassLoader var1, Class<?> var2, List<Method> var3) throws Exception;

    private void initEntries(List<TestCaseEntry> entries) throws Exception {
        for (TestCaseEntry testCaseEntry : entries) {
            Method[] allMethods;
            Class<?> testClass = testCaseEntry.getTestClass();
            for (Method method : allMethods = testClass.getMethods()) {
                if (!this.shouldExecuteTestForMethod(testClass, method)) continue;
                ++this.currentTestIndex;
                if (this.hasChunkAnnotation(method)) {
                    MockTransformer[] mockTransformerArray;
                    LinkedList<Method> methodsInThisChunk = new LinkedList<Method>();
                    methodsInThisChunk.add(method);
                    String[] staticSuppressionClasses = this.getStaticSuppressionClasses(testClass, method);
                    ClassLoader mockClassloader = null;
                    if (null == this.testMethodAnnotation()) {
                        mockTransformerArray = new TestClassTransformer[]{};
                    } else {
                        TestClassTransformer[] testClassTransformerArray = new TestClassTransformer[1];
                        mockTransformerArray = testClassTransformerArray;
                        testClassTransformerArray[0] = TestClassTransformer.forTestClass(testClass).removesTestMethodAnnotation(this.testMethodAnnotation()).fromAllMethodsExcept(method);
                    }
                    MockTransformer[] extraTransformers = mockTransformerArray;
                    mockClassloader = method.isAnnotationPresent(PrepareEverythingForTest.class) ? this.createNewClassloader(testClass, new String[]{"*"}, this.ignorePackagesExtractor.getPackagesToIgnore(testClass), extraTransformers) : this.createNewClassloader(testClass, this.arrayMerger.mergeArrays(String.class, this.prepareForTestExtractor.getTestClasses(method), staticSuppressionClasses), this.ignorePackagesExtractor.getPackagesToIgnore(testClass), extraTransformers);
                    TestChunkImpl chunk = new TestChunkImpl(mockClassloader, methodsInThisChunk);
                    testCaseEntry.getTestChunks().add(chunk);
                    this.updatedIndexes();
                    continue;
                }
                testCaseEntry.getTestChunks().get(0).getTestMethodsToBeExecutedByThisClassloader().add(method);
                int currentDelegateIndex = this.internalSuites.size() - 1;
                List<Integer> testList = this.testAtDelegateMapper.get(currentDelegateIndex);
                if (testList == null) {
                    testList = new LinkedList<Integer>();
                    this.testAtDelegateMapper.put(currentDelegateIndex, testList);
                }
                testList.add(this.currentTestIndex);
            }
        }
    }

    private boolean hasChunkAnnotation(Method method) {
        return method.isAnnotationPresent(PrepareForTest.class) || method.isAnnotationPresent(SuppressStaticInitializationFor.class) || method.isAnnotationPresent(PrepareOnlyThisForTest.class) || method.isAnnotationPresent(PrepareEverythingForTest.class);
    }

    private String[] getStaticSuppressionClasses(Class<?> testClass, Method method) {
        String[] testClasses = method.isAnnotationPresent(SuppressStaticInitializationFor.class) ? this.suppressionExtractor.getTestClasses(method) : this.suppressionExtractor.getTestClasses(testClass);
        return testClasses;
    }

    private void updatedIndexes() {
        LinkedList<Integer> testIndexesForThisClassloader = new LinkedList<Integer>();
        testIndexesForThisClassloader.add(this.currentTestIndex);
        this.testAtDelegateMapper.put(this.internalSuites.size(), testIndexesForThisClassloader);
    }

    @Override
    public int getChunkSize() {
        return this.getTestChunks().size();
    }

    @Override
    public List<TestChunk> getTestChunks() {
        LinkedList<TestChunk> allChunks = new LinkedList<TestChunk>();
        for (TestCaseEntry entry : this.internalSuites) {
            for (TestChunk chunk : entry.getTestChunks()) {
                allChunks.add(chunk);
            }
        }
        return allChunks;
    }

    public int getInternalTestIndex(int originalTestIndex) {
        Set<Map.Entry<Integer, List<Integer>>> delegatorEntrySet = this.testAtDelegateMapper.entrySet();
        for (Map.Entry<Integer, List<Integer>> entry : delegatorEntrySet) {
            List<Integer> testIndexesForThisDelegate = entry.getValue();
            int internalIndex = testIndexesForThisDelegate.indexOf(originalTestIndex);
            if (internalIndex == -1) continue;
            return internalIndex;
        }
        return -1;
    }

    public int getDelegatorIndex(int testIndex) {
        int delegatorIndex = -1;
        Set<Map.Entry<Integer, List<Integer>>> entrySet = this.testAtDelegateMapper.entrySet();
        for (Map.Entry<Integer, List<Integer>> entry : entrySet) {
            if (!entry.getValue().contains(testIndex)) continue;
            delegatorIndex = entry.getKey();
            break;
        }
        if (delegatorIndex == -1) {
            throw new RuntimeException("Internal error: Failed to find the delgator index.");
        }
        return delegatorIndex;
    }

    @Override
    public List<TestChunk> getTestChunksEntries(Class<?> testClass) {
        for (TestCaseEntry entry : this.internalSuites) {
            if (!entry.getTestClass().equals(testClass)) continue;
            return entry.getTestChunks();
        }
        return null;
    }

    public Class<?>[] getTestClasses() {
        return this.testClasses;
    }

    protected boolean hasMockPolicyProvidedClasses(Class<?> testClass) {
        boolean hasMockPolicyProvidedClasses = false;
        if (testClass.isAnnotationPresent(MockPolicy.class)) {
            MockPolicy annotation = testClass.getAnnotation(MockPolicy.class);
            Class<? extends PowerMockPolicy>[] value = annotation.value();
            hasMockPolicyProvidedClasses = new MockPolicyInitializerImpl(value).needsInitialization();
        }
        return hasMockPolicyProvidedClasses;
    }

    private String[] makeSureArrayContainsTestClassName(String[] arrayOfClassNames, String testClassName) {
        if (null == arrayOfClassNames || 0 == arrayOfClassNames.length) {
            return new String[]{testClassName};
        }
        ArrayList<String> modifiedArrayOfClassNames = new ArrayList<String>(arrayOfClassNames.length + 1);
        modifiedArrayOfClassNames.add(testClassName);
        for (String className : arrayOfClassNames) {
            if (testClassName.equals(className)) {
                return arrayOfClassNames;
            }
            modifiedArrayOfClassNames.add(className);
        }
        return modifiedArrayOfClassNames.toArray(new String[arrayOfClassNames.length + 1]);
    }
}

