/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.rule;

import java.util.ArrayList;
import org.powermock.classloading.ClassloaderExecutor;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.transformers.impl.MainMockTransformer;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.proxyframework.RegisterProxyFramework;
import org.powermock.tests.utils.MockPolicyInitializer;
import org.powermock.tests.utils.impl.PowerMockIgnorePackagesExtractorImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;

public class PowerMockClassloaderExecutor {
    public static ClassloaderExecutor forClass(Class<?> testClass, MockPolicyInitializer mockPolicyInitializer) {
        ArrayList<MainMockTransformer> mockTransformerChain = new ArrayList<MainMockTransformer>();
        MainMockTransformer mainMockTransformer = new MainMockTransformer();
        mockTransformerChain.add(mainMockTransformer);
        String[] classesToLoadByMockClassloader = new String[]{};
        String[] packagesToIgnore = new String[]{};
        MockClassLoader mockLoader = new MockClassLoader(classesToLoadByMockClassloader, packagesToIgnore);
        mockLoader.setMockTransformerChain(mockTransformerChain);
        PrepareForTestExtractorImpl testClassesExtractor = new PrepareForTestExtractorImpl();
        StaticConstructorSuppressExtractorImpl staticInitializationExtractor = new StaticConstructorSuppressExtractorImpl();
        PowerMockIgnorePackagesExtractorImpl ignorePackagesExtractor = new PowerMockIgnorePackagesExtractorImpl();
        mockLoader.addIgnorePackage(ignorePackagesExtractor.getPackagesToIgnore(testClass));
        mockLoader.addClassesToModify(testClassesExtractor.getTestClasses(testClass));
        mockLoader.addClassesToModify(staticInitializationExtractor.getTestClasses(testClass));
        PowerMockClassloaderExecutor.registerProxyframework((ClassLoader)mockLoader);
        mockPolicyInitializer.initialize((ClassLoader)mockLoader);
        return new ClassloaderExecutor((ClassLoader)mockLoader);
    }

    private static void registerProxyframework(ClassLoader classLoader) {
        Class<?> proxyFrameworkClass = null;
        try {
            proxyFrameworkClass = Class.forName("org.powermock.api.extension.proxyframework.ProxyFrameworkImpl", false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Extension API internal error: org.powermock.api.extension.proxyframework.ProxyFrameworkImpl could not be located in classpath.");
        }
        Class<?> proxyFrameworkRegistrar = null;
        try {
            proxyFrameworkRegistrar = Class.forName(RegisterProxyFramework.class.getName(), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            Whitebox.invokeMethod(proxyFrameworkRegistrar, (String)"registerProxyFramework", (Object[])new Object[]{Whitebox.newInstance(proxyFrameworkClass)});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

