/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.monacoeditor;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.extensions.component.monacoeditor.MonacoEditorCommon;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.shaded.json.JSONWriter;
import org.primefaces.shaded.owasp.encoder.Encode;
import org.primefaces.util.WidgetBuilder;

abstract class MonacoEditorCommonRenderer<TEditor extends MonacoEditorCommon<TEditorOpts>, TEditorOpts>
extends InputRenderer {
    protected static final String CALLBACK_SIGNATURE = "function()";
    protected final Class<TEditor> componentClass;

    protected MonacoEditorCommonRenderer(Class<TEditor> clazz) {
        this.componentClass = clazz;
    }

    protected abstract void addBaseWidgetProperties(FacesContext var1, WidgetBuilder var2, TEditor var3) throws IOException;

    protected final void array(WidgetBuilder wb, String key, Iterable<String> values) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (String item : values) {
            builder.append('\"');
            builder.append(Encode.forJavaScript((String)item));
            builder.append('\"');
            builder.append(',');
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        wb.nativeAttr(key, builder.toString());
    }

    public final void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MonacoEditorCommon monacoEditor = (MonacoEditorCommon)((Object)this.componentClass.cast(component));
        this.encodeMarkup(context, monacoEditor);
        this.encodeScript(context, monacoEditor);
    }

    protected final void encodeMarkup(FacesContext context, TEditor monacoEditor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = monacoEditor.getClientId();
        String style = monacoEditor.getStyle() != null ? monacoEditor.getStyle() : "";
        style = style.concat(";");
        if (((MonacoEditorCommon)((Object)monacoEditor)).getWidth() != null && !((MonacoEditorCommon)((Object)monacoEditor)).getWidth().isEmpty()) {
            style = style.concat("width:" + ((MonacoEditorCommon)((Object)monacoEditor)).getWidth() + ";");
        }
        if (((MonacoEditorCommon)((Object)monacoEditor)).getHeight() != null && !((MonacoEditorCommon)((Object)monacoEditor)).getHeight().isEmpty()) {
            style = style.concat("height:" + ((MonacoEditorCommon)((Object)monacoEditor)).getHeight() + ";");
        }
        StringBuilder styleClass = new StringBuilder();
        styleClass.append(this.getMainStyleClass() + " ui-hidden-container ");
        if (this.isEntireEditorDisabled(monacoEditor)) {
            styleClass.append("ui-state-disabled ");
        }
        if (monacoEditor.getStyleClass() != null) {
            styleClass.append(monacoEditor.getStyleClass());
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("data-widget-var", (Object)monacoEditor.resolveWidgetVar(), null);
        writer.writeAttribute("class", (Object)styleClass.toString(), null);
        writer.writeAttribute("style", (Object)style, null);
        this.encodeHiddenInput(context, monacoEditor);
        this.encodeMonacoEditor(context, monacoEditor);
        writer.endElement("div");
    }

    protected abstract boolean isEntireEditorDisabled(TEditor var1);

    protected abstract void encodeHiddenInput(FacesContext var1, TEditor var2) throws IOException;

    protected abstract void encodeMonacoEditor(FacesContext var1, TEditor var2) throws IOException;

    protected final void encodeScript(FacesContext context, TEditor monacoEditor) throws IOException {
        WidgetBuilder wb = PrimeRequestContext.getCurrentInstance((FacesContext)context).getWidgetBuilder();
        wb.init(this.getWidgetName(), monacoEditor);
        this.array(wb, "availableEvents", monacoEditor.getEventNames());
        if (((MonacoEditorCommon)((Object)monacoEditor)).getCustomThemes() != null && !((MonacoEditorCommon)((Object)monacoEditor)).getCustomThemes().isEmpty()) {
            wb.nativeAttr("customThemes", JSONWriter.valueToString(((MonacoEditorCommon)((Object)monacoEditor)).getCustomThemes()));
        }
        wb.attr("autoResize", ((MonacoEditorCommon)((Object)monacoEditor)).isAutoResize(), false);
        wb.attr("basename", ((MonacoEditorCommon)((Object)monacoEditor)).getBasename(), "");
        wb.attr("directory", ((MonacoEditorCommon)((Object)monacoEditor)).getDirectory(), "");
        wb.attr("disabled", monacoEditor.isDisabled(), false);
        wb.attr("editorOptions", ((MonacoEditorCommon)((Object)monacoEditor)).getEditorOptions().toString());
        wb.attr("extension", ((MonacoEditorCommon)((Object)monacoEditor)).getExtension(), "");
        wb.attr("language", this.getLanguage(monacoEditor), "plaintext");
        wb.attr("locale", ((MonacoEditorCommon)((Object)monacoEditor)).calculateLocale().toString());
        wb.attr("localeUrl", ((MonacoEditorCommon)((Object)monacoEditor)).getLocaleUrl());
        wb.attr("readonly", monacoEditor.isReadonly(), false);
        wb.attr("scheme", ((MonacoEditorCommon)((Object)monacoEditor)).getScheme(), "inmemory");
        wb.attr("tabIndex", monacoEditor.getTabindex(), MonacoEditorCommon.DEFAULT_TABINDEX);
        wb.attr("height", ((MonacoEditorCommon)((Object)monacoEditor)).getHeight(), "600px");
        wb.attr("width", ((MonacoEditorCommon)((Object)monacoEditor)).getWidth(), "200px");
        wb.callback("onblur", CALLBACK_SIGNATURE, monacoEditor.getOnblur());
        wb.callback("onchange", CALLBACK_SIGNATURE, monacoEditor.getOnchange());
        wb.callback("onfocus", CALLBACK_SIGNATURE, monacoEditor.getOnfocus());
        wb.callback("oninitialized", CALLBACK_SIGNATURE, ((MonacoEditorCommon)((Object)monacoEditor)).getOninitialized());
        wb.callback("onkeyup", CALLBACK_SIGNATURE, monacoEditor.getOnkeyup());
        wb.callback("onmousedown", CALLBACK_SIGNATURE, monacoEditor.getOnmousedown());
        wb.callback("onmousemove", CALLBACK_SIGNATURE, monacoEditor.getOnmousemove());
        wb.callback("onmouseup", CALLBACK_SIGNATURE, monacoEditor.getOnmouseup());
        wb.callback("onkeydown", CALLBACK_SIGNATURE, monacoEditor.getOnkeydown());
        wb.callback("onpaste", CALLBACK_SIGNATURE, ((MonacoEditorCommon)((Object)monacoEditor)).getOnpaste());
        this.addBaseWidgetProperties(context, wb, monacoEditor);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)monacoEditor);
        wb.finish();
    }

    protected abstract String getLanguage(TEditor var1);

    protected abstract String getMainStyleClass();

    protected abstract String getWidgetName();
}

