/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.keynote;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.primefaces.extensions.model.common.KeyData;

public class KeynoteItem
implements KeyData,
Serializable {
    public static final String DEFAULT_TYPE = "default";
    private static final long serialVersionUID = 1L;
    private String key;
    private Serializable data;
    private String type;

    public KeynoteItem() {
        this.setKey(KeynoteItem.generateKey());
    }

    public KeynoteItem(Serializable data) {
        this();
        this.data = data;
        this.type = DEFAULT_TYPE;
    }

    public KeynoteItem(Serializable data, String type) {
        this.data = data;
        this.type = type != null ? type : DEFAULT_TYPE;
        this.setKey(KeynoteItem.generateKey());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public Serializable getData() {
        return this.data;
    }

    @Override
    public void setData(Serializable data) {
        this.data = data;
    }

    public String getType() {
        return this.type;
    }

    public static String generateKey() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeynoteItem)) {
            return false;
        }
        KeynoteItem that = (KeynoteItem)o;
        return Objects.equals(this.getKey(), that.getKey());
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("KeynoteItem [key=");
        builder.append(this.key);
        builder.append(", data=");
        builder.append(this.data);
        builder.append(", type=");
        builder.append(this.type);
        builder.append("]");
        return builder.toString();
    }
}

