/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.sheet;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import java.io.Serializable;
import java.util.Collection;
import org.primefaces.extensions.component.sheet.Sheet;
import org.primefaces.extensions.component.sheet.SheetInvalidUpdate;

public class SheetColumn
extends UIInput
implements ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.SheetColumn";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String MESSAGE_REQUIRED = "A valid value for this column is required.";
    private Object localValue;
    private Sheet sheet;

    public SheetColumn() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void setHeaderText(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.headerText), (Object)value);
    }

    public String getHeaderText() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.headerText), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setReadOnly(boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readOnly), (Object)value);
    }

    public boolean isReadOnly() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readOnly), (Object)Boolean.FALSE).toString());
    }

    public void setReadonlyCell(boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readonlyCell), (Object)value);
    }

    public boolean isReadonlyCell() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readonlyCell), (Object)Boolean.FALSE).toString());
    }

    public void setColWidth(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.colWidth), (Object)value);
    }

    public Integer getColWidth() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.colWidth), null);
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setColType(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.colType), (Object)value);
    }

    public String getColType() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.colType), (Object)"text").toString();
    }

    public boolean isAutoCompleteAllowInvalid() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.autoCompleteAllowInvalid), (Object)Boolean.FALSE).toString());
    }

    public void setAutoCompleteAllowInvalid(boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.autoCompleteAllowInvalid), (Object)value);
    }

    public boolean isAutoCompleteStrict() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.autoCompleteStrict), (Object)Boolean.TRUE).toString());
    }

    public void setAutoCompleteStrict(boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.autoCompleteStrict), (Object)value);
    }

    public boolean isAutoCompleteTrimDropdown() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.autoCompleteTrimDropdown), (Object)Boolean.TRUE).toString());
    }

    public void setAutoCompleteTrimDropdown(boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.autoCompleteTrimDropdown), (Object)value);
    }

    public void setAutoCompleteVisibleRows(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.autoCompleteVisibleRows), (Object)value);
    }

    public Integer getAutoCompleteVisibleRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.autoCompleteVisibleRows), null);
    }

    public Object getSelectItems() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectItems), null);
    }

    public void setSelectItems(Object selectItems) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectItems), selectItems);
    }

    public Integer getPasswordHashLength() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.passwordHashLength), null);
    }

    public void setPasswordHashLength(Integer _passwordHashLength) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.passwordHashLength), (Object)_passwordHashLength);
    }

    public void setPasswordHashSymbol(String _passwordHashSymbol) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.passwordHashSymbol), (Object)_passwordHashSymbol);
    }

    public String getPasswordHashSymbol() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.passwordHashSymbol), (Object)"*");
    }

    public void setNumericPattern(String _numericPattern) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.numericPattern), (Object)_numericPattern);
    }

    public String getNumericPattern() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.numericPattern), (Object)"0 a");
    }

    public String getNumericLocale() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.numericLocale), (Object)"en-US");
    }

    public void setNumericLocale(String locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.numericLocale), (Object)locale);
    }

    public void setDateFormat(String _dateFormat) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dateFormat), (Object)_dateFormat);
    }

    public String getDateFormat() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dateFormat), (Object)"DD/MM/YYYY");
    }

    public void setDatePickerConfig(String _datePickerConfig) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.datePickerConfig), (Object)_datePickerConfig);
    }

    public String getDatePickerConfig() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.datePickerConfig), null);
    }

    public void setTimeFormat(String _timeFormat) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeFormat), (Object)_timeFormat);
    }

    public String getTimeFormat() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeFormat), (Object)"h:mm:ss a");
    }

    public void setOnvalidate(String _onvalidate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onvalidate), (Object)_onvalidate);
    }

    public String getOnvalidate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onvalidate), null);
    }

    public void setVisible(boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.visible), (Object)value);
    }

    public boolean isVisible() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.visible), (Object)Boolean.TRUE).toString());
    }

    public void setWordWrap(boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.wordWrap), (Object)value);
    }

    public Boolean isWordWrap() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.wordWrap), (Object)Boolean.TRUE).toString());
    }

    public void setTrimWhitespace(boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.trimWhitespace), (Object)value);
    }

    public Boolean isTrimWhitespace() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.trimWhitespace), (Object)Boolean.TRUE).toString());
    }

    public void setStyleClass(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)value);
    }

    public String getStyleClass() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public Object getFilterBy() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterBy), null);
    }

    public void setFilterBy(Object filterBy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterBy), filterBy);
    }

    public String getFilterValue() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterValue));
    }

    public void setFilterValue(String filterValue) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterValue), (Object)filterValue);
    }

    public String getFilterMatchMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterMatchMode));
    }

    public void setFilterMatchMode(String filterMatchMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterMatchMode), (Object)filterMatchMode);
    }

    public Collection<SelectItem> getFilterOptions() {
        return (Collection)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterOptions), null);
    }

    public void setFilterOptions(Collection<SelectItem> filterOptions) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterOptions), filterOptions);
    }

    public Sheet getSheet() {
        UIComponent parent;
        if (this.sheet != null) {
            return this.sheet;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof Sheet); parent = parent.getParent()) {
        }
        return (Sheet)parent;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public void setValue(Object value) {
        this.localValue = value;
        this.setLocalValueSet(true);
    }

    public Object getValue() {
        return this.localValue;
    }

    public boolean isValid() {
        return this.getSheet().isValid();
    }

    public void setValid(boolean valid) {
        this.getSheet().setValid(valid);
    }

    public void processDecodes(FacesContext context) {
    }

    public void processUpdates(FacesContext context) {
    }

    public void resetValue() {
        this.setValue(null);
        this.setLocalValueSet(false);
    }

    public void processValidators(FacesContext context) {
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Validator[] validators = this.getValidators();
        Object value = this.getValue();
        if (!this.validateRequired(context, value)) {
            return;
        }
        if (validators == null) {
            return;
        }
        for (Validator validator : validators) {
            try {
                validator.validate(context, (UIComponent)this, value);
            }
            catch (ValidatorException ve) {
                FacesMessage message;
                this.setValid(false);
                String validatorMessageString = this.getValidatorMessage();
                if (null != validatorMessageString) {
                    message = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessageString, validatorMessageString);
                    message.setSeverity(FacesMessage.SEVERITY_ERROR);
                } else {
                    Collection messages = ve.getFacesMessages();
                    if (null != messages) {
                        message = null;
                        String cid = this.getClientId(context);
                        for (FacesMessage m : messages) {
                            context.addMessage(cid, m);
                        }
                    } else {
                        message = ve.getFacesMessage();
                    }
                }
                if (message == null) continue;
                Sheet current = this.getSheet();
                if (current == null) {
                    return;
                }
                context.addMessage(this.getClientId(context), message);
                current.getInvalidUpdates().add(new SheetInvalidUpdate(current.getRowKeyValue(context), current.getColumns().indexOf((Object)this), this, value, message.getDetail()));
            }
        }
    }

    protected boolean validateRequired(FacesContext context, Object newValue) {
        if (this.isValid() && this.isRequired() && UIInput.isEmpty((Object)newValue)) {
            String requiredMessageStr = this.getRequiredMessage();
            FacesMessage message = null != requiredMessageStr ? new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessageStr, requiredMessageStr) : new FacesMessage(FacesMessage.SEVERITY_ERROR, MESSAGE_REQUIRED, MESSAGE_REQUIRED);
            context.addMessage(this.getClientId(context), message);
            Sheet current = this.getSheet();
            if (current != null) {
                current.getInvalidUpdates().add(new SheetInvalidUpdate(current.getRowKeyValue(context), current.getColumns().indexOf((Object)this), this, newValue, message.getDetail()));
            }
            this.setValid(false);
            return false;
        }
        return true;
    }

    static enum PropertyKeys {
        colWidth,
        colType,
        headerText,
        trimWhitespace,
        passwordHashSymbol,
        passwordHashLength,
        numericPattern,
        numericLocale,
        dateFormat,
        datePickerConfig,
        timeFormat,
        autoCompleteStrict,
        autoCompleteAllowInvalid,
        autoCompleteVisibleRows,
        autoCompleteTrimDropdown,
        selectItems,
        readOnly,
        readonlyCell,
        styleClass,
        filterBy,
        filterOptions,
        filterMatchMode,
        filterValue,
        visible,
        wordWrap,
        onvalidate;

    }
}

