/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.keynote;

import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.primefaces.extensions.component.keynote.Keynote;
import org.primefaces.extensions.component.keynote.UIKeynoteItem;
import org.primefaces.extensions.model.keynote.KeynoteItem;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class KeynoteRenderer
extends CoreRenderer {
    public static final String CONTAINER_CLASS = "ui-keynote reveal";
    public static final String SLIDES_CLASS = "slides";

    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        Keynote keynote = (Keynote)component;
        if (!"none".equals(keynote.getTheme())) {
            this.encodeCSS(context, keynote.getLibrary(), keynote.getTheme());
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Keynote keynote = (Keynote)component;
        this.encodeMarkup(context, keynote);
        this.encodeScript(context, keynote);
    }

    private void encodeMarkup(FacesContext context, Keynote keynote) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = keynote.getClientId(context);
        String styleClass = this.getStyleClassBuilder(context).add(CONTAINER_CLASS).add(keynote.getStyleClass()).build();
        writer.startElement("div", (UIComponent)keynote);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (keynote.getStyle() != null) {
            writer.writeAttribute("style", (Object)keynote.getStyle(), "style");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)SLIDES_CLASS, "class");
        if (keynote.getVar() != null) {
            Object value = keynote.getValue();
            if (value != null) {
                if (!(value instanceof Collection)) {
                    throw new FacesException("Value in Keynote must be of type Collection / List");
                }
                List children = keynote.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    UIComponent kid = (UIComponent)children.get(i);
                    if (!kid.isRendered() || kid instanceof UIKeynoteItem) continue;
                    this.renderChild(context, kid);
                }
                Collection col = (Collection)value;
                for (int i = 0; i < col.size(); ++i) {
                    KeynoteItem keynoteItem = (KeynoteItem)col.toArray()[i];
                    UIKeynoteItem uiItem = keynote.getItem(keynoteItem.getType());
                    if (!uiItem.isRendered()) continue;
                    keynote.setData(keynoteItem);
                    this.renderChild(context, (UIComponent)uiItem);
                }
            }
        } else {
            List children = keynote.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                UIComponent kid = (UIComponent)children.get(i);
                if (!kid.isRendered()) continue;
                this.renderChild(context, kid);
            }
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, Keynote keynote) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtKeynote", (UIComponent)keynote).attr("width", keynote.getWidth(), 960).attr("height", keynote.getHeight(), 700).attr("margin", keynote.getMargin().doubleValue(), 0.04).attr("minScale", keynote.getMinScale().doubleValue(), 0.2).attr("maxScale", keynote.getMaxScale().doubleValue(), 2.0).attr("autoSlide", keynote.getAutoSlide(), 0).attr("center", keynote.isCenter().booleanValue(), true).attr("controls", keynote.isControls().booleanValue(), true).attr("disableLayout", keynote.isDisableLayout().booleanValue(), false).attr("embedded", keynote.isEmbedded().booleanValue(), false).attr("loop", keynote.isLoop().booleanValue(), false).attr("navigationMode", keynote.getNavigationMode(), "default").attr("progress", keynote.isProgress().booleanValue(), true).attr("showNotes", keynote.isShowNotes().booleanValue(), false).attr("slideNumber", keynote.getSlideNumber(), "false").attr("touch", keynote.isTouch().booleanValue(), true).attr("transition", keynote.getTransition(), "slide").attr("transitionSpeed", keynote.getTransitionSpeed(), "default").attr("backgroundTransition", keynote.getBackgroundTransition(), "fade").attr("theme", keynote.getTheme(), "none");
        this.encodeClientBehaviors(context, keynote);
        wb.finish();
    }

    private void encodeCSS(FacesContext context, String library, String theme) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ExternalContext externalContext = context.getExternalContext();
        Resource cssResource = context.getApplication().getResourceHandler().createResource("keynote/theme/" + theme + ".css", library);
        if (cssResource == null) {
            throw new FacesException("Error loading CSS, cannot find \"" + theme + "\" resource of \"" + library + "\" library");
        }
        writer.startElement("link", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("href", (Object)externalContext.encodeResourceURL(cssResource.getRequestPath()), null);
        writer.endElement("link");
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

