/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.orgchart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.primefaces.extensions.component.orgchart.OrgChartNode;

public class OrgChartHelper {
    private OrgChartHelper() {
    }

    public static List<OrgChartNode> getAllNodesTraverseFromRoot(OrgChartNode root) {
        ArrayList<OrgChartNode> orgChartNodes = new ArrayList<OrgChartNode>();
        OrgChartHelper.treeTraversal(root, orgChartNodes);
        return orgChartNodes;
    }

    public static Map<String, OrgChartNode> parseOrgChartNodesIntoHashMap(List<OrgChartNode> orgChartNodes) {
        HashMap<String, OrgChartNode> hashMap = new HashMap<String, OrgChartNode>();
        if (orgChartNodes != null && !orgChartNodes.isEmpty()) {
            if (null == orgChartNodes.get(0).getId() || orgChartNodes.get(0).getId().isEmpty()) {
                return hashMap;
            }
            for (OrgChartNode o : orgChartNodes) {
                hashMap.put(o.getId(), o);
            }
        }
        return hashMap;
    }

    private static void treeTraversal(OrgChartNode orgChartNode, List<OrgChartNode> orgChartNodes) {
        if (orgChartNode.getChildCount() > 0) {
            for (OrgChartNode o : orgChartNode.getChildren()) {
                OrgChartHelper.treeTraversal(o, orgChartNodes);
            }
        }
        orgChartNodes.add(orgChartNode);
    }
}

