/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.clockpicker;

import jakarta.el.ValueExpression;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;
import java.text.DateFormatSymbols;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.extensions.component.clockpicker.ClockPicker;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class ClockPickerRenderer
extends InputRenderer {
    private static final DateTimeFormatter FORMATTER_24_HOUR = DateTimeFormatter.ofPattern("HH:mm");

    public void decode(FacesContext context, UIComponent component) {
        ClockPicker clockPicker = (ClockPicker)component;
        if (clockPicker.isDisabled() || clockPicker.isReadonly()) {
            return;
        }
        String param = clockPicker.getClientId(context) + "_input";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(param);
        if (null != submittedValue) {
            clockPicker.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ClockPicker clockPicker = (ClockPicker)component;
        Locale locale = clockPicker.calculateLocale(context);
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        String value = ClockPickerRenderer.getValueAsString(context, clockPicker);
        this.encodeMarkup(context, clockPicker, value, symbols);
        this.encodeScript(context, clockPicker, symbols);
    }

    private void encodeMarkup(FacesContext context, ClockPicker clockPicker, String value, DateFormatSymbols symbols) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = clockPicker.getClientId();
        String inputId = clientId + "_input";
        String[] ampm = symbols.getAmPmStrings();
        int inputSize = clockPicker.isTwelveHour() != false ? 5 + ampm[0].length() : 5;
        writer.startElement("div", (UIComponent)clockPicker);
        writer.writeAttribute("id", (Object)clientId, null);
        Object containerClass = "pe-clockpicker ui-widget ui-corner-all clockpicker";
        if (clockPicker.isShowOnButton()) {
            containerClass = (String)containerClass + " ui-inputgroup";
        }
        writer.writeAttribute("class", containerClass, null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("size", (Object)inputSize, null);
        writer.writeAttribute("maxlength", (Object)inputSize, null);
        String styleClass = this.createStyleClass((UIInput)clockPicker, "ui-inputfield ui-widget ui-state-default ui-corner-all");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (clockPicker.getStyle() != null) {
            writer.writeAttribute("style", (Object)clockPicker.getStyle(), null);
        }
        if (LangUtils.isNotBlank((String)value)) {
            writer.writeAttribute("value", (Object)value, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)clockPicker);
        this.renderPassThruAttributes(context, (UIComponent)clockPicker, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)clockPicker, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)clockPicker, new ClientValidator[0]);
        writer.endElement("input");
        if (clockPicker.isShowOnButton()) {
            writer.startElement("button", null);
            writer.writeAttribute("class", (Object)"pe-clockpicker-trigger ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only input-group-addon", null);
            writer.writeAttribute("type", (Object)"button", null);
            writer.writeAttribute("role", (Object)"button", null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-button-icon-left ui-icon ui-icon-clock", null);
            writer.endElement("span");
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-button-text", null);
            writer.write("ui-button");
            writer.endElement("span");
            writer.endElement("button");
        }
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, ClockPicker clockPicker, DateFormatSymbols symbols) throws IOException {
        String[] ampm = symbols.getAmPmStrings();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtClockPicker", (UIComponent)clockPicker);
        wb.attr("appendTo", SearchExpressionUtils.resolveOptionalClientIdForClientSide((FacesContext)context, (UIComponent)clockPicker, (String)clockPicker.getAppendTo()));
        wb.attr("placement", clockPicker.getPlacement(), "bottom");
        wb.attr("align", clockPicker.getAlign(), "left");
        wb.attr("autoclose", clockPicker.isAutoClose().booleanValue(), false);
        wb.attr("vibrate", clockPicker.getVibrate().booleanValue(), true);
        wb.attr("twelvehour", clockPicker.isTwelveHour().booleanValue(), false);
        wb.attr("amtext", ampm[0], "AM");
        wb.attr("pmtext", ampm[1], "PM");
        if (clockPicker.getOnbeforehourselect() != null) {
            wb.callback("beforeHourSelect", "function()", clockPicker.getOnbeforehourselect());
        }
        if (clockPicker.getOnbeforedone() != null) {
            wb.callback("beforeDone", "function()", clockPicker.getOnbeforedone());
        }
        if (clockPicker.getOnbeforeshow() != null) {
            wb.callback("beforeShow", "function()", clockPicker.getOnbeforeshow());
        }
        if (clockPicker.getOnbeforehide() != null) {
            wb.callback("beforeHide", "function()", clockPicker.getOnbeforehide());
        }
        if (clockPicker.getOnafterhourselect() != null) {
            wb.callback("afterHourSelect", "function()", clockPicker.getOnafterhourselect());
        }
        if (clockPicker.getOnafterdone() != null) {
            wb.callback("afterDone", "function()", clockPicker.getOnafterdone());
        }
        if (clockPicker.getOnaftershow() != null) {
            wb.callback("afterShow", "function()", clockPicker.getOnaftershow());
        }
        if (clockPicker.getOnafterhide() != null) {
            wb.callback("afterHide", "function()", clockPicker.getOnafterhide());
        }
        if (clockPicker.getOnafterampmselect() != null) {
            wb.callback("afterAmPmSelect", "function()", clockPicker.getOnafterampmselect());
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)clockPicker);
        wb.finish();
    }

    protected static String getValueAsString(FacesContext context, ClockPicker clockPicker) {
        Object submittedValue = clockPicker.getSubmittedValue();
        if (submittedValue != null) {
            return submittedValue.toString();
        }
        Object value = clockPicker.getValue();
        if (value == null) {
            return null;
        }
        try {
            if (clockPicker.getConverter() != null) {
                return clockPicker.getConverter().getAsString(context, (UIComponent)clockPicker, value);
            }
            if (value instanceof LocalTime) {
                return clockPicker.isTwelveHour() != false ? ((LocalTime)value).format(DateTimeFormatter.ofPattern("hh:mma").withLocale(clockPicker.calculateLocale(context))) : ((LocalTime)value).format(FORMATTER_24_HOUR);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        ClockPicker clockPicker = (ClockPicker)component;
        String submittedValue = Objects.toString(value, null);
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        try {
            Converter converter = clockPicker.getConverter();
            if (converter != null) {
                return converter.getAsObject(context, (UIComponent)clockPicker, submittedValue);
            }
        }
        catch (ConverterException e) {
            return submittedValue;
        }
        try {
            Class type;
            ValueExpression ve = clockPicker.getValueExpression("value");
            if (ve != null && (type = ve.getType(context.getELContext())) != null && submittedValue != null && type.isAssignableFrom(LocalTime.class)) {
                return clockPicker.isTwelveHour() != false ? LocalTime.parse(submittedValue, DateTimeFormatter.ofPattern("hh:mma").withLocale(clockPicker.calculateLocale(context))) : LocalTime.parse(submittedValue, FORMATTER_24_HOUR);
            }
        }
        catch (Exception e) {
            return submittedValue;
        }
        return submittedValue;
    }
}

