/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.keynote;

import jakarta.faces.FacesException;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.primefaces.component.api.PrimeClientBehaviorHolder;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.component.base.AbstractDynamicData;
import org.primefaces.extensions.component.keynote.UIKeynoteItem;
import org.primefaces.extensions.event.KeynoteEvent;
import org.primefaces.extensions.model.common.KeyData;
import org.primefaces.extensions.model.keynote.KeynoteItem;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="keynote/keynote.js"), @ResourceDependency(library="primefaces-extensions", name="keynote/keynote.css")})
public class Keynote
extends AbstractDynamicData
implements Widget,
ClientBehaviorHolder,
PrimeClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.Keynote";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.KeynoteRenderer";
    private static final String DEFAULT_EVENT = "slideChanged";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put((Object)"slideTransitionEnd", null).put((Object)"slideChanged", null).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private Map<String, UIKeynoteItem> items;

    public Keynote() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public int getWidth() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.width), (Object)960);
    }

    public void setWidth(int width) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.width), (Object)width);
    }

    public int getHeight() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.height), (Object)700);
    }

    public void setHeight(int height) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.height), (Object)height);
    }

    public Double getMargin() {
        return (Double)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.margin), (Object)0.04);
    }

    public void setMargin(Double margin) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.margin), (Object)margin);
    }

    public Double getMinScale() {
        return (Double)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minScale), (Object)0.2);
    }

    public void setMinScale(Double minScale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minScale), (Object)minScale);
    }

    public Double getMaxScale() {
        return (Double)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxScale), (Object)2.0);
    }

    public void setMaxScale(Double maxScale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxScale), (Object)maxScale);
    }

    public int getAutoSlide() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.autoSlide), (Object)0);
    }

    public void setAutoSlide(int autoSlide) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.autoSlide), (Object)autoSlide);
    }

    public Boolean isCenter() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.center), (Object)true);
    }

    public void setCenter(Boolean center) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.center), (Object)center);
    }

    public Boolean isControls() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.controls), (Object)true);
    }

    public void setControls(Boolean controls) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.controls), (Object)controls);
    }

    public Boolean isDisableLayout() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disableLayout), (Object)false);
    }

    public void setDisableLayout(Boolean disableLayout) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disableLayout), (Object)disableLayout);
    }

    public Boolean isEmbedded() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.embedded), (Object)false);
    }

    public void setEmbedded(Boolean embedded) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.embedded), (Object)embedded);
    }

    public Boolean isLoop() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.loop), (Object)false);
    }

    public void setLoop(Boolean loop) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.loop), (Object)loop);
    }

    public String getNavigationMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.navigationMode), (Object)"default");
    }

    public void setNavigationMode(String navigationMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.navigationMode), (Object)navigationMode);
    }

    public Boolean isProgress() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.progress), (Object)true);
    }

    public void setProgress(Boolean progress) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.progress), (Object)progress);
    }

    public Boolean isShowNotes() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showNotes), (Object)false);
    }

    public void setShowNotes(Boolean showNotes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showNotes), (Object)showNotes);
    }

    public String getSlideNumber() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.slideNumber), (Object)"false");
    }

    public void setSlideNumber(String slideNumber) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.slideNumber), (Object)slideNumber);
    }

    public Boolean isTouch() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.touch), (Object)true);
    }

    public void setTouch(Boolean touch) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.touch), (Object)touch);
    }

    public String getTransition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.transition), (Object)"slide");
    }

    public void setTransition(String transition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.transition), (Object)transition);
    }

    public String getTransitionSpeed() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.transitionSpeed), (Object)"default");
    }

    public void setTransitionSpeed(String transitionSpeed) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.transitionSpeed), (Object)transitionSpeed);
    }

    public String getBackgroundTransition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.backgroundTransition), (Object)"fade");
    }

    public void setBackgroundTransition(String backgroundTransition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.backgroundTransition), (Object)backgroundTransition);
    }

    public String getTheme() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.theme), (Object)"none");
    }

    public void setTheme(String theme) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.theme), (Object)theme);
    }

    public String getLibrary() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.library), (Object)"primefaces-extensions");
    }

    public void setLibrary(String library) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.library), (Object)library);
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)widgetVar);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)styleClass);
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (event instanceof AjaxBehaviorEvent) {
            FacesContext context = this.getFacesContext();
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("jakarta.faces.behavior.event");
            if ("slideTransitionEnd".equals(eventName)) {
                boolean slideTransitionEnd = Boolean.parseBoolean((String)params.get(this.getClientId(context) + "_slideTransitionEnd"));
                boolean lastSlide = Boolean.parseBoolean((String)params.get(this.getClientId(context) + "_lastSlide"));
                KeynoteEvent keynoteEvent = new KeynoteEvent((UIComponent)this, behaviorEvent.getBehavior(), slideTransitionEnd, lastSlide);
                keynoteEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)keynoteEvent);
            } else if (DEFAULT_EVENT.equals(eventName)) {
                boolean slideChanged = Boolean.parseBoolean((String)params.get(this.getClientId(context) + "_slideChanged"));
                boolean lastSlide = Boolean.parseBoolean((String)params.get(this.getClientId(context) + "_lastSlide"));
                KeynoteEvent keynoteEvent = new KeynoteEvent((UIComponent)this, behaviorEvent.getBehavior(), slideChanged, lastSlide);
                keynoteEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)keynoteEvent);
            } else {
                super.queueEvent(event);
            }
        } else {
            super.queueEvent(event);
        }
    }

    public UIKeynoteItem getItem(String type) {
        UIKeynoteItem item = this.getItems().get(type);
        if (item == null) {
            throw new FacesException("UIKeynoteItem to type " + type + " was not found");
        }
        return item;
    }

    protected Map<String, UIKeynoteItem> getItems() {
        if (this.items == null) {
            this.items = new HashMap<String, UIKeynoteItem>();
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof UIKeynoteItem)) continue;
                UIKeynoteItem keynoteItem = (UIKeynoteItem)child;
                this.items.put(keynoteItem.getType(), keynoteItem);
            }
        }
        return this.items;
    }

    protected static void checkModelInstance(Object value) {
        if (!(value instanceof Collection)) {
            throw new FacesException("Value in Keynote must be of type Collection / List");
        }
    }

    @Override
    protected KeyData findData(String key) {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        Keynote.checkModelInstance(value);
        Collection col = (Collection)value;
        for (KeynoteItem keynoteItem : col) {
            if (!key.equals(keynoteItem.getKey())) continue;
            return keynoteItem;
        }
        return null;
    }

    @Override
    protected void processChildren(FacesContext context, PhaseId phaseId) {
        if (this.getVar() != null) {
            Object value = this.getValue();
            if (value != null) {
                Keynote.checkModelInstance(value);
                Collection col = (Collection)value;
                for (KeynoteItem keynoteItem : col) {
                    this.processKeynoteDynamicItems(context, phaseId, keynoteItem);
                }
            }
            this.resetData();
        } else {
            this.processKeynoteStaticItems(context, phaseId);
        }
    }

    @Override
    protected boolean visitChildren(VisitContext context, VisitCallback callback) {
        if (this.getVar() != null) {
            Object value = this.getValue();
            if (value == null) {
                return false;
            }
            Keynote.checkModelInstance(value);
            Collection col = (Collection)value;
            for (KeynoteItem keynoteItem : col) {
                if (!this.visitKeynoteDynamicItems(context, callback, keynoteItem)) continue;
                return true;
            }
        } else {
            return this.visitKeynoteStaticItems(context, callback);
        }
        this.resetData();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean invokeOnChildren(FacesContext context, String clientId, ContextCallback callback) {
        Object value = this.getValue();
        if (value == null) {
            return false;
        }
        Keynote.checkModelInstance(value);
        if (this.getChildCount() > 0) {
            String key = clientId.substring(this.getClientId().length() + 1);
            key = key.substring(0, key.indexOf(UINamingContainer.getSeparatorChar((FacesContext)context)));
            Collection keynoteItems = (Collection)value;
            for (KeynoteItem keynoteItem : keynoteItems) {
                if (!keynoteItem.getKey().equals(key)) continue;
                UIKeynoteItem uiKeynoteItem = null;
                if (this.getVar() == null) {
                    for (UIComponent child : this.getChildren()) {
                        if (!(child instanceof UIKeynoteItem) || !((UIKeynoteItem)child).getType().equals(keynoteItem.getType())) continue;
                        uiKeynoteItem = (UIKeynoteItem)child;
                    }
                } else {
                    uiKeynoteItem = (UIKeynoteItem)((Object)this.getChildren().get(0));
                }
                if (uiKeynoteItem == null) continue;
                try {
                    this.setData(keynoteItem);
                    if (!uiKeynoteItem.invokeOnComponent(context, clientId, callback)) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.resetData();
                }
            }
        }
        return false;
    }

    private void processKeynoteDynamicItems(FacesContext context, PhaseId phaseId, KeynoteItem keynoteItem) {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof UIKeynoteItem) || !kid.isRendered() || !((UIKeynoteItem)kid).getType().equals(keynoteItem.getType())) continue;
            for (UIComponent grandkid : kid.getChildren()) {
                if (!grandkid.isRendered()) continue;
                this.setData(keynoteItem);
                if (this.getData() == null) {
                    return;
                }
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    grandkid.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    grandkid.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    grandkid.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    private void processKeynoteStaticItems(FacesContext context, PhaseId phaseId) {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof UIKeynoteItem) || !kid.isRendered()) continue;
            for (UIComponent grandkid : kid.getChildren()) {
                if (!grandkid.isRendered()) continue;
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    grandkid.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    grandkid.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    grandkid.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    private boolean visitKeynoteDynamicItems(VisitContext context, VisitCallback callback, KeynoteItem keynoteItem) {
        if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof UIKeynoteItem) || !((UIKeynoteItem)child).getType().equals(keynoteItem.getType())) continue;
                this.setData(keynoteItem);
                if (this.getData() == null) {
                    return false;
                }
                if (!child.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean visitKeynoteStaticItems(VisitContext context, VisitCallback callback) {
        if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof UIKeynoteItem) || !child.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object saveState(FacesContext context) {
        this.items = null;
        return super.saveState(context);
    }

    protected static enum PropertyKeys {
        widgetVar,
        width,
        height,
        margin,
        minScale,
        maxScale,
        autoSlide,
        center,
        controls,
        disableLayout,
        embedded,
        loop,
        navigationMode,
        progress,
        showNotes,
        slideNumber,
        touch,
        transition,
        transitionSpeed,
        backgroundTransition,
        theme,
        library,
        style,
        styleClass;

    }
}

