/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.inputotp;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.primefaces.component.api.AbstractPrimeHtmlInputText;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.component.inputphone.InputPhone;
import org.primefaces.extensions.util.ExtLangUtils;
import org.primefaces.extensions.util.MessageFactory;
import org.primefaces.util.LangUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces-extensions", name="inputotp/inputotp.css"), @ResourceDependency(library="primefaces-extensions", name="inputotp/inputotp.js")})
public class InputOtp
extends AbstractPrimeHtmlInputText
implements Widget,
InputHolder,
RTLAware {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.InputOtp";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.InputOtpRenderer";
    public static final String STYLE_CLASS = "ui-inputotp ui-widget";
    public static final String RTL_STYLE_CLASS = "ui-inputotp-rtl";
    public static final String CELL_STYLE_CLASS = "ui-inputotp-input ui-inputfield ui-inputtext ui-widget ui-state-default";
    public static final String SEPARATOR_STYLE_CLASS = "ui-inputotp-separator";
    public static final String INPUT_SUFFIX = "_input";
    public static final String HIDDEN_SUFFIX = "_hidden";
    public static final List<String> INPUT_OTP_ATTRIBUTES_WITHOUT_EVENTS = List.of("accesskey", "alt", "autocomplete", "dir", "lang", "inputmode", "tabindex", "title");

    public InputOtp() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getInputClientId() {
        return this.getClientId() + "_input1";
    }

    public String getValidatableInputClientId() {
        return this.getClientId() + HIDDEN_SUFFIX;
    }

    public String getLabelledBy() {
        return (String)this.getStateHelper().get((Serializable)((Object)"labelledby"));
    }

    public void setLabelledBy(String labelledBy) {
        this.getStateHelper().put((Serializable)((Object)"labelledby"), (Object)labelledBy);
    }

    public String getPlaceholder() {
        return (String)this.getStateHelper().eval((Serializable)((Object)InputPhone.PropertyKeys.placeholder), null);
    }

    public void setPlaceholder(String placeholder) {
        this.getStateHelper().put((Serializable)((Object)InputPhone.PropertyKeys.placeholder), (Object)placeholder);
    }

    public String getAutocomplete() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.autocomplete), (Object)"off");
    }

    public boolean isIntegerOnly() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.integerOnly), (Object)false);
    }

    public void setIntegerOnly(boolean integerOnly) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.integerOnly), (Object)integerOnly);
    }

    public String getInputStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.inputStyle), null);
    }

    public void setInputStyle(String inputStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.inputStyle), (Object)inputStyle);
    }

    public String getInputStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.inputStyleClass), null);
    }

    public void setInputStyleClass(String inputStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.inputStyleClass), (Object)inputStyleClass);
    }

    public String getSeparator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.separator), null);
    }

    public void setSeparator(String separator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.separator), (Object)separator);
    }

    public String getAriaLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.ariaLabel), null);
    }

    public void setAriaLabel(String ariaLabel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.ariaLabel), (Object)ariaLabel);
    }

    public int getLength() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.length), (Object)4);
    }

    public void setLength(int length) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.length), (Object)length);
    }

    public boolean isMask() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mask), (Object)false);
    }

    public void setMask(boolean mask) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mask), (Object)mask);
    }

    protected void validateValue(FacesContext context, Object newValue) {
        boolean isDigit;
        super.validateValue(context, newValue);
        if (!this.isValid()) {
            return;
        }
        String submittedValue = Objects.toString(this.getSubmittedValue(), "");
        if (LangUtils.isEmpty((String)submittedValue)) {
            return;
        }
        if (this.isValid() && this.isRequired() && submittedValue.length() != this.getLength()) {
            String requiredMessageStr = this.getRequiredMessage();
            FacesMessage message = null != requiredMessageStr ? new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessageStr, requiredMessageStr) : MessageFactory.getMessage("jakarta.faces.component.UIInput.REQUIRED", FacesMessage.SEVERITY_ERROR, MessageFactory.getLabel(context, (UIComponent)this));
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
        if (this.isValid() && this.isIntegerOnly() && !(isDigit = ExtLangUtils.isDigitsOnly(submittedValue))) {
            FacesMessage message;
            this.setValid(false);
            String validatorMessage = this.getValidatorMessage();
            if (validatorMessage != null) {
                message = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage);
            } else {
                String exampleValue = "9".repeat(this.getSize());
                message = MessageFactory.getMessage("jakarta.faces.converter.NumberConverter.NUMBER", FacesMessage.SEVERITY_ERROR, this.getSubmittedValue(), exampleValue, MessageFactory.getLabel(context, (UIComponent)this));
            }
            context.addMessage(this.getClientId(context), message);
        }
    }

    public static enum PropertyKeys {
        placeholder,
        autocomplete,
        integerOnly,
        inputStyle,
        inputStyleClass,
        separator,
        ariaLabel,
        length,
        mask;

    }
}

