/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.letteravatar;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.letteravatar.LetterAvatar;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;

public class LetterAvatarRenderer
extends CoreRenderer {
    private static final Pattern VALUE_PATTTERN = Pattern.compile("\\b[a-zA-Z]");

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        LetterAvatar letterAvatar = (LetterAvatar)component;
        this.encodeMarkup(context, letterAvatar);
    }

    public void encodeMarkup(FacesContext context, LetterAvatar letterAvatar) throws IOException {
        String backgroundColor;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = letterAvatar.getClientId(context);
        String value = letterAvatar.getValue();
        Matcher m = VALUE_PATTTERN.matcher(value);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            sb.append(m.group());
        }
        String initials = sb.toString();
        initials = initials.length() == 1 ? initials : initials.charAt(0) + initials.substring(initials.length() - 1);
        boolean rounded = letterAvatar.isRounded();
        String color = letterAvatar.getColor();
        if (LangUtils.isValueBlank((String)color)) {
            color = "#fff";
        }
        if (LangUtils.isValueBlank((String)(backgroundColor = letterAvatar.getBackgroundColor()))) {
            backgroundColor = "hsl(" + LetterAvatarRenderer.hue(value) + ", 100%, 50%)";
        }
        String size = letterAvatar.getSize();
        String style = LetterAvatarRenderer.joinStyle(letterAvatar.getStyle(), this.styleContainer(size, color, backgroundColor));
        String styleClass = LetterAvatarRenderer.joinStyleClass(letterAvatar.getStyleClass(), "ui-letteravatar");
        writer.startElement("span", (UIComponent)letterAvatar);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("title", (Object)value, null);
        if (rounded) {
            styleClass = styleClass + " " + "ui-letteravatar-rounded";
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.renderChildren(context, (UIComponent)letterAvatar);
        writer.startElement("span", (UIComponent)letterAvatar);
        writer.writeAttribute("class", (Object)"ui-letteravatar-initials", null);
        writer.writeAttribute("style", (Object)this.styleInitials(size), null);
        writer.write(initials);
        writer.endElement("span");
        writer.endElement("span");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public static int hash(String str) {
        int result = 0;
        for (int i = 0; i < str.length(); ++i) {
            result = (result << 5) - result + str.charAt(i);
        }
        return result;
    }

    public static int hue(String str) {
        return Math.abs(LetterAvatarRenderer.hash(str) % 360);
    }

    protected String styleContainer(String size, String color, String backgroundColor) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(8);
        map.put("color", color);
        map.put("background-color", backgroundColor);
        map.put("height", size);
        map.put("width", size);
        return LetterAvatarRenderer.toStyle(map);
    }

    protected String styleInitials(String size) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(8);
        map.put("font-size", "calc(" + size + " / 2)");
        map.put("top", "calc(" + size + " / 4)");
        return LetterAvatarRenderer.toStyle(map);
    }

    protected static String joinNonNull(String delimiter, String ... parts) {
        return Stream.of(parts).filter(Objects::nonNull).collect(Collectors.joining(delimiter));
    }

    protected static String joinStyle(String ... parts) {
        return LetterAvatarRenderer.joinNonNull("", parts);
    }

    protected static String joinStyleClass(String ... parts) {
        return LetterAvatarRenderer.joinNonNull(" ", parts);
    }

    protected static String toStyle(Map<String, String> map) {
        return map.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(";"));
    }
}

