/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.ckeditor;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class ResourceModifier {
    private static final String PROJECT_DIRECTORY = "C:\\dev\\primefaces\\primefaces-extensions\\ckeditor";
    private static final String SHORT_HASH = "LAI9";
    private static final String URL_PFE = "url\\(\"#{resource['primefaces-extensions:";
    private static final int INDEX_NOT_FOUND = -1;

    public static void main(String[] args) throws IOException {
        String resourcesDirectory = "C:\\dev\\primefaces\\primefaces-extensions\\ckeditor/src/main/resources/META-INF/resources/primefaces-extensions/";
        ResourceModifier.log("######## Modify skin styles....C:\\dev\\primefaces\\primefaces-extensions\\ckeditor/src/main/resources/META-INF/resources/primefaces-extensions/");
        File skinsPath = new File("C:\\dev\\primefaces\\primefaces-extensions\\ckeditor/src/main/resources/META-INF/resources/primefaces-extensions/ckeditor/skins/");
        for (String skin : Objects.requireNonNull(skinsPath.list())) {
            ResourceModifier.log("#### Modify skin '" + skin + "'");
            File skinDirectory = new File("C:\\dev\\primefaces\\primefaces-extensions\\ckeditor/src/main/resources/META-INF/resources/primefaces-extensions/ckeditor/skins/" + skin);
            String relativeSkinPath = ResourceModifier.replace(ResourceModifier.replace(skinDirectory.getPath(), "C:\\dev\\primefaces\\primefaces-extensions\\ckeditor/src/main/resources/META-INF/resources/primefaces-extensions/", ""), "\\", "/");
            for (File resourceToModify : Objects.requireNonNull(skinDirectory.listFiles())) {
                if (!resourceToModify.getName().endsWith(".css")) continue;
                ResourceModifier.log("## Modify file '" + resourceToModify.getName() + "'");
                String fileContent = FileUtils.readFileToString((File)resourceToModify, (Charset)Charset.defaultCharset());
                List<File> allSkinResources = ResourceModifier.getResourcesList(skinDirectory);
                for (File resource : allSkinResources) {
                    if (resource.getName().endsWith(".css")) continue;
                    String relativeResourcePath = ResourceModifier.replace(ResourceModifier.replace(resource.getPath(), "C:\\dev\\primefaces\\primefaces-extensions\\ckeditor/src/main/resources/META-INF/resources/primefaces-extensions/", ""), "\\", "/");
                    String resourceName = ResourceModifier.replace(resource.getAbsolutePath().replace(skinDirectory.getAbsolutePath(), ""), "\\", "/");
                    if (resourceName != null && resourceName.startsWith("/")) {
                        resourceName = resourceName.substring(1);
                    }
                    fileContent = fileContent.replaceAll("url\\(" + resourceName + "\\)", URL_PFE + relativeResourcePath + "']}\"\\)");
                }
                fileContent = fileContent.replaceAll("url\\(icons.png\\?t=LAI9", URL_PFE + relativeSkinPath + "/icons.png']}&t=" + SHORT_HASH + "\"");
                fileContent = fileContent.replaceAll("url\\(icons_hidpi.png\\?t=LAI9", URL_PFE + relativeSkinPath + "/icons_hidpi.png']}&t=" + SHORT_HASH + "\"");
                FileUtils.writeStringToFile((File)resourceToModify, (String)fileContent, (Charset)Charset.defaultCharset());
            }
            File file = new File("C:\\dev\\primefaces\\primefaces-extensions\\ckeditor/src/main/resources/META-INF/resources/primefaces-extensions/ckeditor/plugins/smiley/dialogs/smiley.js");
            String fileContent = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()).replaceAll("CKEDITOR.tools.htmlEncode\\(e\\.smiley_path\\+h\\[a\\]\\)", "CKEDITOR.tools.htmlEncode\\(CKEDITOR.getUrl\\(e\\.smiley_path\\+h\\[a\\]\\)\\)");
            FileUtils.writeStringToFile((File)file, (String)fileContent, (Charset)Charset.defaultCharset());
        }
        File file = new File("C:\\dev\\primefaces\\primefaces-extensions\\ckeditor/src/main/resources/META-INF/resources/primefaces-extensions/ckeditor/ckeditor.js");
        String fileContent = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        fileContent = fileContent.replaceAll("this.path\\+(\\t|\\r?\\n)?\"styles/copyformatting.css\"", "CKEDITOR.getUrl(this.path\\+\"styles/copyformatting.css\")");
        fileContent = fileContent.replaceAll("this.path\\+(\\t|\\r?\\n)?\"skins/\"\\+(\\t|\\r?\\n)?CKEDITOR.skin.name\\+(\\t|\\r?\\n)?\"/scayt.css\"", "CKEDITOR.getUrl(this.path\\+\"skins/\"\\+CKEDITOR.skin.name\\+\"/scayt.css\")");
        fileContent = fileContent.replaceAll("this.path\\+(\\t|\\r?\\n)?\"skins/\"\\+(\\t|\\r?\\n)?CKEDITOR.skin.name\\+(\\t|\\r?\\n)?\"/wsc.css\"", "CKEDITOR.getUrl(this.path\\+\"skins/\"\\+CKEDITOR.skin.name\\+\"/wsc.css\")");
        fileContent = fileContent.replaceAll("this.path\\+(\\t|\\r?\\n)?\"styles/dialog.css\"", "CKEDITOR.getUrl(this.path\\+\"styles/dialog.css\")");
        fileContent = fileContent.replaceAll("this.path\\+(\\t|\\r?\\n)?\"styles/tableselection.css\"", "CKEDITOR.getUrl(this.path\\+\"styles/tableselection.css\")");
        fileContent = fileContent.replaceAll("CKEDITOR.plugins.get\\(\"mathjax\"\\).path\\+(\\t|\\r?\\n)?\"images/loader.gif\"", "CKEDITOR.getUrl(CKEDITOR.plugins.get\\(\"mathjax\"\\).path\\+\"images/loader.gif\")");
        fileContent = fileContent.replaceAll("b.plugins.widget.path\\+(\\t|\\r?\\n)?\"images/handle.png", "CKEDITOR.getUrl(b.plugins.widget.path\\+\"images/handle.png\")\\+\"");
        FileUtils.writeStringToFile((File)file, (String)fileContent, (Charset)Charset.defaultCharset());
    }

    private static List<File> getResourcesList(File file) {
        String name = file.getName();
        ArrayList<File> result = new ArrayList<File>();
        if (file.isDirectory()) {
            for (File f : Objects.requireNonNull(file.listFiles())) {
                result.addAll(ResourceModifier.getResourcesList(f));
            }
        } else if (name.endsWith(".png") || name.endsWith(".css")) {
            result.add(file);
        }
        return result;
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return seq.toString().indexOf(searchSeq.toString(), startPos);
    }

    public static String replace(String text, String searchString, String replacement) {
        if (ResourceModifier.isEmpty(text) || ResourceModifier.isEmpty(searchString) || replacement == null) {
            return text;
        }
        int max = -1;
        int start = 0;
        int end = ResourceModifier.indexOf(text, searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = Math.max(increase, 0);
        StringBuilder buf = new StringBuilder(text.length() + (increase *= 16));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = ResourceModifier.indexOf(text, searchString, start);
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static void log(String message) {
        System.err.println(message);
    }
}

