/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import lombok.core.AST;
import lombok.javac.CompilerMessageSuppressor;
import lombok.javac.Javac;
import lombok.javac.JavacASTVisitor;
import lombok.javac.JavacImportList;
import lombok.javac.JavacNode;
import lombok.javac.JavacTreeMaker;

public class JavacAST
extends AST<JavacAST, JavacNode, JCTree> {
    private final Messager messager;
    private final JavacElements elements;
    private final JavacTreeMaker treeMaker;
    private final Symtab symtab;
    private final JavacTypes javacTypes;
    private final Log log;
    private final Context context;
    private static boolean JCTRY_RESOURCES_FIELD_INITIALIZED;
    private static Field JCTRY_RESOURCES_FIELD;

    public JavacAST(Messager messager, Context context, JCTree.JCCompilationUnit top) {
        super(JavacAST.sourceName(top), JavacAST.packageDeclaration(top), new JavacImportList(top));
        this.setTop(this.buildCompilationUnit(top));
        this.context = context;
        this.messager = messager;
        this.log = Log.instance(context);
        this.elements = JavacElements.instance(context);
        this.treeMaker = new JavacTreeMaker(TreeMaker.instance(context));
        this.symtab = Symtab.instance(context);
        this.javacTypes = JavacTypes.instance(context);
        this.clearChanged();
    }

    private static String sourceName(JCTree.JCCompilationUnit cu) {
        return cu.sourcefile == null ? null : cu.sourcefile.toString();
    }

    private static String packageDeclaration(JCTree.JCCompilationUnit cu) {
        return cu.pid instanceof JCTree.JCFieldAccess || cu.pid instanceof JCTree.JCIdent ? cu.pid.toString() : null;
    }

    public Context getContext() {
        return this.context;
    }

    public void traverse(JavacASTVisitor visitor) {
        ((JavacNode)this.top()).traverse(visitor);
    }

    void traverseChildren(JavacASTVisitor visitor, JavacNode node) {
        for (JavacNode child : node.down()) {
            child.traverse(visitor);
        }
    }

    @Override
    public int getSourceVersion() {
        try {
            String nm = Source.instance(this.context).name();
            int underscoreIdx = nm.indexOf(95);
            if (underscoreIdx > -1) {
                return Integer.parseInt(nm.substring(underscoreIdx + 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 6;
    }

    @Override
    public int getLatestJavaSpecSupported() {
        return Javac.getJavaCompilerVersion();
    }

    public Name toName(String name) {
        return this.elements.getName(name);
    }

    public JavacTreeMaker getTreeMaker() {
        this.treeMaker.at(-1);
        return this.treeMaker;
    }

    public Symtab getSymbolTable() {
        return this.symtab;
    }

    public JavacTypes getTypesUtil() {
        return this.javacTypes;
    }

    @Override
    protected JavacNode buildTree(JCTree node, AST.Kind kind) {
        switch (kind) {
            case COMPILATION_UNIT: {
                return this.buildCompilationUnit((JCTree.JCCompilationUnit)node);
            }
            case TYPE: {
                return this.buildType((JCTree.JCClassDecl)node);
            }
            case FIELD: {
                return this.buildField((JCTree.JCVariableDecl)node);
            }
            case INITIALIZER: {
                return this.buildInitializer((JCTree.JCBlock)node);
            }
            case METHOD: {
                return this.buildMethod((JCTree.JCMethodDecl)node);
            }
            case ARGUMENT: {
                return this.buildLocalVar((JCTree.JCVariableDecl)node, kind);
            }
            case LOCAL: {
                return this.buildLocalVar((JCTree.JCVariableDecl)node, kind);
            }
            case STATEMENT: {
                return this.buildStatementOrExpression(node);
            }
            case ANNOTATION: {
                return this.buildAnnotation((JCTree.JCAnnotation)node, false);
            }
        }
        throw new AssertionError((Object)("Did not expect: " + (Object)((Object)kind)));
    }

    private JavacNode buildCompilationUnit(JCTree.JCCompilationUnit top) {
        ArrayList<JavacNode> childNodes = new ArrayList<JavacNode>();
        for (JCTree s : top.defs) {
            if (!(s instanceof JCTree.JCClassDecl)) continue;
            JavacAST.addIfNotNull(childNodes, this.buildType((JCTree.JCClassDecl)s));
        }
        return new JavacNode(this, top, (java.util.List<JavacNode>)childNodes, AST.Kind.COMPILATION_UNIT);
    }

    private JavacNode buildType(JCTree.JCClassDecl type) {
        if (this.setAndGetAsHandled(type)) {
            return null;
        }
        ArrayList<JavacNode> childNodes = new ArrayList<JavacNode>();
        for (JCTree.JCAnnotation annotation : type.mods.annotations) {
            JavacAST.addIfNotNull(childNodes, this.buildAnnotation(annotation, false));
        }
        for (JCTree def : type.defs) {
            if (def instanceof JCTree.JCMethodDecl) {
                JavacAST.addIfNotNull(childNodes, this.buildMethod((JCTree.JCMethodDecl)def));
                continue;
            }
            if (def instanceof JCTree.JCClassDecl) {
                JavacAST.addIfNotNull(childNodes, this.buildType((JCTree.JCClassDecl)def));
                continue;
            }
            if (def instanceof JCTree.JCVariableDecl) {
                JavacAST.addIfNotNull(childNodes, this.buildField((JCTree.JCVariableDecl)def));
                continue;
            }
            if (!(def instanceof JCTree.JCBlock)) continue;
            JavacAST.addIfNotNull(childNodes, this.buildInitializer((JCTree.JCBlock)def));
        }
        return this.putInMap(new JavacNode(this, type, (java.util.List<JavacNode>)childNodes, AST.Kind.TYPE));
    }

    private JavacNode buildField(JCTree.JCVariableDecl field) {
        if (this.setAndGetAsHandled(field)) {
            return null;
        }
        ArrayList<JavacNode> childNodes = new ArrayList<JavacNode>();
        for (JCTree.JCAnnotation annotation : field.mods.annotations) {
            JavacAST.addIfNotNull(childNodes, this.buildAnnotation(annotation, true));
        }
        JavacAST.addIfNotNull(childNodes, this.buildExpression(field.init));
        return this.putInMap(new JavacNode(this, field, (java.util.List<JavacNode>)childNodes, AST.Kind.FIELD));
    }

    private JavacNode buildLocalVar(JCTree.JCVariableDecl local, AST.Kind kind) {
        if (this.setAndGetAsHandled(local)) {
            return null;
        }
        ArrayList<JavacNode> childNodes = new ArrayList<JavacNode>();
        for (JCTree.JCAnnotation annotation : local.mods.annotations) {
            JavacAST.addIfNotNull(childNodes, this.buildAnnotation(annotation, true));
        }
        JavacAST.addIfNotNull(childNodes, this.buildExpression(local.init));
        return this.putInMap(new JavacNode(this, local, (java.util.List<JavacNode>)childNodes, kind));
    }

    private static java.util.List<JCTree> getResourcesForTryNode(JCTree.JCTry tryNode) {
        if (!JCTRY_RESOURCES_FIELD_INITIALIZED) {
            try {
                JCTRY_RESOURCES_FIELD = JCTree.JCTry.class.getField("resources");
            }
            catch (NoSuchFieldException ignore) {
            }
            catch (Exception ignore) {
                // empty catch block
            }
            JCTRY_RESOURCES_FIELD_INITIALIZED = true;
        }
        if (JCTRY_RESOURCES_FIELD == null) {
            return Collections.emptyList();
        }
        Object rv = null;
        try {
            rv = JCTRY_RESOURCES_FIELD.get(tryNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rv instanceof java.util.List) {
            return (java.util.List)rv;
        }
        return Collections.emptyList();
    }

    private JavacNode buildTry(JCTree.JCTry tryNode) {
        if (this.setAndGetAsHandled(tryNode)) {
            return null;
        }
        ArrayList<JavacNode> childNodes = new ArrayList<JavacNode>();
        for (JCTree varDecl : JavacAST.getResourcesForTryNode(tryNode)) {
            if (!(varDecl instanceof JCTree.JCVariableDecl)) continue;
            JavacAST.addIfNotNull(childNodes, this.buildLocalVar((JCTree.JCVariableDecl)varDecl, AST.Kind.LOCAL));
        }
        JavacAST.addIfNotNull(childNodes, this.buildStatement(tryNode.body));
        for (JCTree.JCCatch jcc : tryNode.catchers) {
            JavacAST.addIfNotNull(childNodes, this.buildTree(jcc, AST.Kind.STATEMENT));
        }
        JavacAST.addIfNotNull(childNodes, this.buildStatement(tryNode.finalizer));
        return this.putInMap(new JavacNode(this, tryNode, (java.util.List<JavacNode>)childNodes, AST.Kind.STATEMENT));
    }

    private JavacNode buildInitializer(JCTree.JCBlock initializer) {
        if (this.setAndGetAsHandled(initializer)) {
            return null;
        }
        ArrayList<JavacNode> childNodes = new ArrayList<JavacNode>();
        for (JCTree.JCStatement statement : initializer.stats) {
            JavacAST.addIfNotNull(childNodes, this.buildStatement(statement));
        }
        return this.putInMap(new JavacNode(this, initializer, (java.util.List<JavacNode>)childNodes, AST.Kind.INITIALIZER));
    }

    private JavacNode buildMethod(JCTree.JCMethodDecl method) {
        if (this.setAndGetAsHandled(method)) {
            return null;
        }
        ArrayList<JavacNode> childNodes = new ArrayList<JavacNode>();
        for (JCTree.JCAnnotation annotation : method.mods.annotations) {
            JavacAST.addIfNotNull(childNodes, this.buildAnnotation(annotation, false));
        }
        for (JCTree.JCVariableDecl param : method.params) {
            JavacAST.addIfNotNull(childNodes, this.buildLocalVar(param, AST.Kind.ARGUMENT));
        }
        if (method.body != null && method.body.stats != null) {
            for (JCTree.JCStatement statement : method.body.stats) {
                JavacAST.addIfNotNull(childNodes, this.buildStatement(statement));
            }
        }
        return this.putInMap(new JavacNode(this, method, (java.util.List<JavacNode>)childNodes, AST.Kind.METHOD));
    }

    private JavacNode buildAnnotation(JCTree.JCAnnotation annotation, boolean varDecl) {
        boolean handled = this.setAndGetAsHandled(annotation);
        if (!varDecl && handled) {
            return null;
        }
        return this.putInMap(new JavacNode(this, annotation, null, AST.Kind.ANNOTATION));
    }

    private JavacNode buildExpression(JCTree.JCExpression expression) {
        return this.buildStatementOrExpression(expression);
    }

    private JavacNode buildStatement(JCTree.JCStatement statement) {
        return this.buildStatementOrExpression(statement);
    }

    private JavacNode buildStatementOrExpression(JCTree statement) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof JCTree.JCAnnotation) {
            return null;
        }
        if (statement instanceof JCTree.JCClassDecl) {
            return this.buildType((JCTree.JCClassDecl)statement);
        }
        if (statement instanceof JCTree.JCVariableDecl) {
            return this.buildLocalVar((JCTree.JCVariableDecl)statement, AST.Kind.LOCAL);
        }
        if (statement instanceof JCTree.JCTry) {
            return this.buildTry((JCTree.JCTry)statement);
        }
        if (this.setAndGetAsHandled(statement)) {
            return null;
        }
        return this.drill(statement);
    }

    private JavacNode drill(JCTree statement) {
        try {
            ArrayList<JavacNode> childNodes = new ArrayList<JavacNode>();
            for (AST.FieldAccess fa : this.fieldsOf(statement.getClass())) {
                childNodes.addAll(this.buildWithField(JavacNode.class, statement, fa));
            }
            return this.putInMap(new JavacNode(this, statement, (java.util.List<JavacNode>)childNodes, AST.Kind.STATEMENT));
        }
        catch (OutOfMemoryError oome) {
            String msg = oome.getMessage();
            if (msg == null) {
                msg = "(no original message)";
            }
            OutOfMemoryError newError = new OutOfMemoryError(this.getFileName() + "@pos" + statement.getPreferredPosition() + ": " + msg);
            throw newError;
        }
    }

    @Override
    protected Collection<Class<? extends JCTree>> getStatementTypes() {
        ArrayList<Class<? extends JCTree>> collection = new ArrayList<Class<? extends JCTree>>(3);
        collection.add(JCTree.JCStatement.class);
        collection.add(JCTree.JCExpression.class);
        collection.add(JCTree.JCCatch.class);
        return collection;
    }

    private static void addIfNotNull(Collection<JavacNode> nodes, JavacNode node) {
        if (node != null) {
            nodes.add(node);
        }
    }

    void removeDeferredErrors(JavacNode node) {
        JCDiagnostic.DiagnosticPosition pos = ((JCTree)node.get()).pos();
        JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)this.top()).get();
        this.removeFromDeferredDiagnostics(pos.getStartPosition(), Javac.getEndPosition(pos, top));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printMessage(Diagnostic.Kind kind, String message, JavacNode node, JCDiagnostic.DiagnosticPosition pos, boolean attemptToRemoveErrorsInRange) {
        JavaFileObject oldSource = null;
        JavaFileObject newSource = null;
        JCTree astObject = node == null ? null : (JCTree)node.get();
        JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)this.top()).get();
        newSource = top.sourcefile;
        if (newSource != null) {
            oldSource = this.log.useSource(newSource);
            if (pos == null) {
                pos = astObject.pos();
            }
        }
        if (pos != null && attemptToRemoveErrorsInRange) {
            this.removeFromDeferredDiagnostics(pos.getStartPosition(), node.getEndPosition(pos));
        }
        try {
            switch (kind) {
                case ERROR: {
                    this.increaseErrorCount(this.messager);
                    boolean prev = this.log.multipleErrors;
                    this.log.multipleErrors = true;
                    try {
                        this.log.error(pos, "proc.messager", new Object[]{message});
                        break;
                    }
                    finally {
                        this.log.multipleErrors = prev;
                    }
                }
                default: {
                    this.log.warning(pos, "proc.messager", new Object[]{message});
                    break;
                }
            }
        }
        finally {
            if (oldSource != null) {
                this.log.useSource(oldSource);
            }
        }
    }

    private void removeFromDeferredDiagnostics(int startPos, int endPos) {
        JCTree.JCCompilationUnit self = (JCTree.JCCompilationUnit)((JavacNode)this.top()).get();
        new CompilerMessageSuppressor(this.getContext()).removeAllBetween(self.sourcefile, startPos, endPos);
    }

    @Override
    protected void setElementInASTCollection(Field field, Object refField, java.util.List<Collection<?>> chain, Collection<?> collection, int idx, JCTree newN) throws IllegalAccessException {
        List<?> list = this.setElementInConsList(chain, collection, ((java.util.List)collection).get(idx), newN);
        field.set(refField, list);
    }

    private List<?> setElementInConsList(java.util.List<Collection<?>> chain, Collection<?> current, Object oldO, Object newO) {
        List oldL = (List)current;
        List<?> newL = this.replaceInConsList(oldL, oldO, newO);
        if (chain.isEmpty()) {
            return newL;
        }
        ArrayList reducedChain = new ArrayList(chain);
        Collection newCurrent = (Collection)reducedChain.remove(reducedChain.size() - 1);
        return this.setElementInConsList(reducedChain, newCurrent, oldL, newL);
    }

    private List<?> replaceInConsList(List<?> oldL, Object oldO, Object newO) {
        boolean repl = false;
        Object[] a = oldL.toArray();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != oldO) continue;
            a[i] = newO;
            repl = true;
        }
        if (repl) {
            return List.from(a);
        }
        return oldL;
    }

    private void increaseErrorCount(Messager m) {
        try {
            Field f = m.getClass().getDeclaredField("errorCount");
            f.setAccessible(true);
            if (f.getType() == Integer.TYPE) {
                int val2 = ((Number)f.get(m)).intValue();
                f.set(m, val2 + 1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

