/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol.websocket.ietf07;

import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;
import org.projectodd.stilts.stomp.protocol.websocket.DefaultWebSocketFrame;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketFrame;

public class Ietf07WebSocketFrameDecoder
extends ReplayingDecoder<VoidEnum> {
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    private final int maxFrameSize;
    private static final Logger log = Logger.getLogger(Ietf07WebSocketFrameDecoder.class);

    public Ietf07WebSocketFrameDecoder() {
        this(16384);
    }

    public Ietf07WebSocketFrameDecoder(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        log.info((Object)("READABLE! " + this.actualReadableBytes()));
        byte finOpcode = buffer.readByte();
        boolean fin = (finOpcode & 1) != 0;
        int opcode = finOpcode >> 4;
        byte lengthMask = buffer.readByte();
        boolean masked = (lengthMask & 0x80) != 0;
        log.info((Object)("masked=" + masked));
        long length = lengthMask & 0x7F;
        log.info((Object)("length.1=" + length));
        if (length == 126L) {
            length = buffer.readShort();
        } else if (length == 127L) {
            length = buffer.readLong();
        }
        log.info((Object)("length.2=" + length));
        if (length > (long)this.maxFrameSize) {
            throw new TooLongFrameException();
        }
        log.info((Object)"HI -AA");
        byte[] mask = null;
        log.info((Object)"HI -BB");
        if (masked) {
            mask = new byte[4];
            buffer.readBytes(mask);
        }
        log.info((Object)("HI -CC " + this.actualReadableBytes()));
        byte[] payload = new byte[(int)length];
        log.info((Object)"reading payload");
        buffer.readBytes(payload);
        log.info((Object)"read payload");
        if (masked) {
            for (int i = 0; i < payload.length; ++i) {
                payload[i] = (byte)(payload[i] ^ mask[i % 4]);
            }
        }
        log.info((Object)("Payload unmasked: " + new String(payload)));
        ChannelBuffer data = ChannelBuffers.wrappedBuffer((byte[])payload);
        WebSocketFrame.FrameType frameType = this.decodeFrameType(opcode);
        return new DefaultWebSocketFrame(frameType, data);
    }

    protected WebSocketFrame.FrameType decodeFrameType(int opcode) {
        switch (opcode) {
            case 0: {
                return WebSocketFrame.FrameType.CONTINUATION;
            }
            case 1: {
                return WebSocketFrame.FrameType.TEXT;
            }
            case 2: {
                return WebSocketFrame.FrameType.BINARY;
            }
            case 8: {
                return WebSocketFrame.FrameType.CLOSE;
            }
            case 9: {
                return WebSocketFrame.FrameType.PING;
            }
            case 10: {
                return WebSocketFrame.FrameType.PONG;
            }
        }
        return null;
    }
}

