/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp;

import org.projectodd.stilts.stomp.DefaultStompMessage;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.StompMessage;

public class StompMessages {
    private StompMessages() {
    }

    public static StompMessage createStompMessage() {
        return new DefaultStompMessage();
    }

    public static StompMessage createStompMessage(String destination, String content) {
        DefaultStompMessage message = new DefaultStompMessage();
        message.setDestination(destination);
        message.setContentAsString(content);
        return message;
    }

    public static StompMessage createStompMessage(String destination, Headers headers, String content) {
        DefaultStompMessage message = new DefaultStompMessage(headers, content);
        message.setDestination(destination);
        return message;
    }

    public static StompMessage createStompErrorMessage(String messageHeader) {
        DefaultStompMessage message = new DefaultStompMessage();
        message.getHeaders().put("message", messageHeader);
        message.setError(true);
        return message;
    }

    public static StompMessage createStompErrorMessage(String messageHeader, String content) {
        DefaultStompMessage message = new DefaultStompMessage();
        message.getHeaders().put("message", messageHeader);
        message.setContentAsString(content);
        message.setError(true);
        return message;
    }

    public static StompMessage createStompErrorMessage(Headers headers, String content) {
        return new DefaultStompMessage(headers, content, true);
    }
}

