/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.xs.util;

import java.util.AbstractList;
import org.python.apache.xerces.xs.ShortList;
import org.python.apache.xerces.xs.XSException;

public final class ShortListImpl
extends AbstractList
implements ShortList {
    public static final ShortListImpl EMPTY_LIST = new ShortListImpl(new short[0], 0);
    private final short[] fArray;
    private final int fLength;

    public ShortListImpl(short[] sArray, int n) {
        this.fArray = sArray;
        this.fLength = n;
    }

    public int getLength() {
        return this.fLength;
    }

    public boolean contains(short s) {
        int n = 0;
        while (n < this.fLength) {
            if (this.fArray[n] == s) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public short item(int n) throws XSException {
        if (n < 0 || n >= this.fLength) {
            throw new XSException(2, null);
        }
        return this.fArray[n];
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ShortList)) {
            return false;
        }
        ShortList shortList = (ShortList)object;
        if (this.fLength != shortList.getLength()) {
            return false;
        }
        int n = 0;
        while (n < this.fLength) {
            if (this.fArray[n] != shortList.item(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Object get(int n) {
        if (n >= 0 && n < this.fLength) {
            return new Short(this.fArray[n]);
        }
        throw new IndexOutOfBoundsException("Index: " + n);
    }

    public int size() {
        return this.getLength();
    }
}

