/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.asn1.ua;

import java.math.BigInteger;
import java.util.Random;
import org.python.bouncycastle.math.ec.ECConstants;
import org.python.bouncycastle.math.ec.ECCurve;
import org.python.bouncycastle.math.ec.ECFieldElement;
import org.python.bouncycastle.math.ec.ECPoint;
import org.python.bouncycastle.util.Arrays;

public abstract class DSTU4145PointEncoder {
    private static BigInteger trace(ECFieldElement eCFieldElement) {
        ECFieldElement eCFieldElement2 = eCFieldElement;
        for (int i = 0; i < eCFieldElement.getFieldSize() - 1; ++i) {
            eCFieldElement2 = eCFieldElement2.square().add(eCFieldElement);
        }
        return eCFieldElement2.toBigInteger();
    }

    private static ECFieldElement solveQuadraticEquation(ECCurve eCCurve, ECFieldElement eCFieldElement) {
        if (eCFieldElement.isZero()) {
            return eCFieldElement;
        }
        ECFieldElement eCFieldElement2 = eCCurve.fromBigInteger(ECConstants.ZERO);
        ECFieldElement eCFieldElement3 = null;
        ECFieldElement eCFieldElement4 = null;
        Random random2 = new Random();
        int n = eCFieldElement.getFieldSize();
        do {
            ECFieldElement eCFieldElement5 = eCCurve.fromBigInteger(new BigInteger(n, random2));
            eCFieldElement3 = eCFieldElement2;
            ECFieldElement eCFieldElement6 = eCFieldElement;
            for (int i = 1; i <= n - 1; ++i) {
                ECFieldElement eCFieldElement7 = eCFieldElement6.square();
                eCFieldElement3 = eCFieldElement3.square().add(eCFieldElement7.multiply(eCFieldElement5));
                eCFieldElement6 = eCFieldElement7.add(eCFieldElement);
            }
            if (eCFieldElement6.isZero()) continue;
            return null;
        } while ((eCFieldElement4 = eCFieldElement3.square().add(eCFieldElement3)).isZero());
        return eCFieldElement3;
    }

    public static byte[] encodePoint(ECPoint eCPoint) {
        eCPoint = eCPoint.normalize();
        ECFieldElement eCFieldElement = eCPoint.getAffineXCoord();
        byte[] byArray = eCFieldElement.getEncoded();
        if (!eCFieldElement.isZero()) {
            ECFieldElement eCFieldElement2 = eCPoint.getAffineYCoord().divide(eCFieldElement);
            if (DSTU4145PointEncoder.trace(eCFieldElement2).equals(ECConstants.ONE)) {
                int n = byArray.length - 1;
                byArray[n] = (byte)(byArray[n] | 1);
            } else {
                int n = byArray.length - 1;
                byArray[n] = (byte)(byArray[n] & 0xFE);
            }
        }
        return byArray;
    }

    public static ECPoint decodePoint(ECCurve eCCurve, byte[] byArray) {
        BigInteger bigInteger = BigInteger.valueOf(byArray[byArray.length - 1] & 1);
        if (!DSTU4145PointEncoder.trace(eCCurve.fromBigInteger(new BigInteger(1, byArray))).equals(eCCurve.getA().toBigInteger())) {
            byArray = Arrays.clone(byArray);
            int n = byArray.length - 1;
            byArray[n] = (byte)(byArray[n] ^ 1);
        }
        ECFieldElement eCFieldElement = eCCurve.fromBigInteger(new BigInteger(1, byArray));
        ECFieldElement eCFieldElement2 = null;
        if (eCFieldElement.isZero()) {
            eCFieldElement2 = (ECFieldElement.F2m)eCCurve.getB();
            for (int i = 0; i < eCCurve.getFieldSize() - 1; ++i) {
                eCFieldElement2 = ((ECFieldElement)eCFieldElement2).square();
            }
        } else {
            ECFieldElement eCFieldElement3 = eCFieldElement.add(eCCurve.getA()).add(eCCurve.getB().multiply(eCFieldElement.square().invert()));
            ECFieldElement eCFieldElement4 = DSTU4145PointEncoder.solveQuadraticEquation(eCCurve, eCFieldElement3);
            if (eCFieldElement4 == null) {
                throw new RuntimeException("Invalid point compression");
            }
            if (!DSTU4145PointEncoder.trace(eCFieldElement4).equals(bigInteger)) {
                eCFieldElement4 = eCFieldElement4.addOne();
            }
            eCFieldElement2 = eCFieldElement.multiply(eCFieldElement4);
        }
        return new ECPoint.F2m(eCCurve, eCFieldElement, eCFieldElement2);
    }
}

