/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.dictgenerator;

import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.quickfixj.dictgenerator.Component;
import org.quickfixj.dictgenerator.ComponentComponent;
import org.quickfixj.dictgenerator.ComponentField;
import org.quickfixj.dictgenerator.Enum;
import org.quickfixj.dictgenerator.Field;
import org.quickfixj.dictgenerator.MsgType;
import org.quickfixj.dictgenerator.MsgTypeComponent;
import org.quickfixj.dictgenerator.MsgTypeField;

public class Repository {
    private final File repository;
    private final Document components;
    private final Document enums;
    private final Document fields;
    private final Document msgContents;
    private final Document msgType;
    private final Map<String, MsgType> sessionMsgTypes = new TreeMap<String, MsgType>();
    private final Map<String, MsgType> applicationMsgTypes = new TreeMap<String, MsgType>();
    private final Map<String, Field> allFields = new TreeMap<String, Field>();
    private final Map<String, Component> allComponents = new TreeMap<String, Component>();

    public Repository(File repositoryFile) throws Exception {
        this.repository = repositoryFile;
        HashSet<String> requiredFiles = new HashSet<String>();
        requiredFiles.add("Components.xml");
        requiredFiles.add("Enums.xml");
        requiredFiles.add("Fields.xml");
        requiredFiles.add("MsgContents.xml");
        requiredFiles.add("MsgType.xml");
        for (File file : this.repository.listFiles()) {
            requiredFiles.remove(file.getName());
        }
        if (!requiredFiles.isEmpty()) {
            throw new Exception("Invalid repository: Missing required files: " + requiredFiles);
        }
        SAXReader reader = SAXReader.createDefault();
        this.components = reader.read(new File(this.repository, "Components.xml"));
        this.enums = reader.read(new File(this.repository, "Enums.xml"));
        this.fields = reader.read(new File(this.repository, "Fields.xml"));
        this.msgContents = reader.read(new File(this.repository, "MsgContents.xml"));
        this.msgType = reader.read(new File(this.repository, "MsgType.xml"));
        this.initFields();
        this.initComponents();
        this.initMsgTypes(this.sessionMsgTypes, "1");
        this.initMsgTypes(this.applicationMsgTypes, "0");
    }

    public final Map<String, MsgType> getSessionMsgTypes() {
        return this.sessionMsgTypes;
    }

    public final Component getStandardHeader(MsgType msgType) {
        for (Object o : msgType.getMsgContent()) {
            if (!(o instanceof Component) || !((Component)o).isStandardHeader()) continue;
            return (Component)o;
        }
        return null;
    }

    public final Component getStandardTrailer(MsgType msgType) {
        for (Object o : msgType.getMsgContent()) {
            if (!(o instanceof Component) || !((Component)o).isStandardTrailer()) continue;
            return (Component)o;
        }
        return null;
    }

    public final Map<String, MsgType> getApplicationMsgTypes() {
        return this.applicationMsgTypes;
    }

    public final Map<String, Field> getFields() {
        return this.allFields;
    }

    public final Map<String, Component> getComponents() {
        return this.allComponents;
    }

    private void initMsgTypes(Map<String, MsgType> msgTypeMap, String notReqXML) {
        System.out.println(this.getClass().getSimpleName() + ": Init MsgTypes (" + notReqXML + ")...");
        List msgTypeNodes = this.msgType.selectNodes("//dataroot/MsgType[NotReqXML=" + notReqXML + "]");
        for (Object o : msgTypeNodes) {
            Node node = (Node)o;
            String msgID = this.getSingleNodeTextSafe(node, "MsgID");
            String messageName = this.getSingleNodeTextSafe(node, "MessageName");
            String componentType = this.getSingleNodeTextSafe(node, "ComponentType");
            String category = this.getSingleNodeTextSafe(node, "Category");
            String msgType = this.getSingleNodeTextSafe(node, "MsgType");
            msgTypeMap.put(msgType, new MsgType(msgID, messageName, componentType, category, notReqXML, msgType));
        }
        System.out.println(this.getClass().getSimpleName() + ": " + msgTypeMap.size() + " MsgTypes found");
        for (MsgType msgType : msgTypeMap.values()) {
            List<?> msgContentsNodes = this.getMsgContents(msgType.getMsgID());
            System.out.println("\t " + msgType.getName());
            for (Object o : msgContentsNodes) {
                Node node = (Node)o;
                String tagText = this.getSingleNodeTextSafe(node, "TagText");
                String reqd = this.getSingleNodeTextSafe(node, "Reqd");
                if (this.allFields.containsKey(tagText)) {
                    MsgTypeField msgTypeField = new MsgTypeField(this.allFields.get(tagText), reqd);
                    msgType.addMsgContent(msgTypeField);
                    System.out.println("\t\t " + this.allFields.get(tagText).getFieldName());
                    continue;
                }
                if (this.allComponents.containsKey(tagText)) {
                    MsgTypeComponent msgTypeComponent = new MsgTypeComponent(this.allComponents.get(tagText), reqd);
                    msgType.addMsgContent(msgTypeComponent);
                    System.out.println("\t\t " + this.allComponents.get(tagText).getName());
                    continue;
                }
                System.err.println("Could not find tagText: " + tagText);
            }
        }
    }

    private void initFields() {
        System.out.println(this.getClass().getSimpleName() + ": Init Fields...");
        List fieldNodes = this.fields.selectNodes("//dataroot/Fields");
        for (Object o : fieldNodes) {
            Node node = (Node)o;
            String tag = this.getSingleNodeTextSafe(node, "Tag");
            String fieldName = this.getSingleNodeTextSafe(node, "FieldName");
            System.out.println("\t " + fieldName + "(" + tag + ")");
            String type = this.getSingleNodeTextSafe(node, "Type");
            String desc = this.getSingleNodeTextSafe(node, "Desc");
            String notReqXML = this.getSingleNodeTextSafe(node, "NotReqXML");
            Field field = new Field(tag, fieldName, type, desc, notReqXML);
            this.allFields.put(field.getTag(), field);
            List enumNodes = this.enums.selectNodes("//dataroot/Enums[Tag=" + tag + "]");
            enumNodes.sort(new EnumNodeComparator());
            if (enumNodes.isEmpty()) continue;
            for (Object enumO : enumNodes) {
                Node enumNode = (Node)enumO;
                String enumName = this.getSingleNodeTextSafe(enumNode, "Enum");
                System.out.println("\t\t " + enumName);
                String enumDesc = this.getSingleNodeTextSafe(enumNode, "Description");
                field.addEnum(new Enum(enumName, enumDesc));
            }
        }
        System.out.println(this.getClass().getSimpleName() + ": " + this.allFields.size() + " Fields found");
    }

    private String getSingleNodeTextSafe(Node node, String tag) {
        Node nodeWithTag = node.selectSingleNode(tag);
        if (nodeWithTag != null) {
            return nodeWithTag.getText();
        }
        throw new RuntimeException("Node with tag " + tag + " not found in " + node.getPath());
    }

    private void initComponents() {
        System.out.println(this.getClass().getSimpleName() + ": Init Components...");
        List componentNodes = this.components.selectNodes("//dataroot/Components");
        for (Object o : componentNodes) {
            Node node = (Node)o;
            String msgID = this.getSingleNodeTextSafe(node, "MsgID");
            String componentName = this.getSingleNodeTextSafe(node, "ComponentName");
            String componentType = this.getSingleNodeTextSafe(node, "ComponentType");
            String category = this.getSingleNodeTextSafe(node, "Category");
            String notReqXML = this.getSingleNodeTextSafe(node, "NotReqXML");
            this.allComponents.put(componentName, new Component(msgID, componentName, componentType, category, notReqXML));
        }
        System.out.println(this.getClass().getSimpleName() + ": " + this.allComponents.size() + " Components found");
        for (Component component : this.allComponents.values()) {
            this.addComponentMsgContent(component, "\t");
        }
    }

    private void addComponentMsgContent(Component component, String prefix) {
        List<?> msgContentsNodes = this.getMsgContents(component.getMsgID());
        System.out.println(prefix + " " + component.getName());
        if (!component.getMsgContent().isEmpty()) {
            System.out.println(prefix + "\talready handled, return");
            return;
        }
        for (Object o : msgContentsNodes) {
            Node node = (Node)o;
            String tagText = this.getSingleNodeTextSafe(node, "TagText");
            String reqd = this.getSingleNodeTextSafe(node, "Reqd");
            if (this.allFields.containsKey(tagText)) {
                ComponentField componentField = new ComponentField(this.allFields.get(tagText), reqd);
                component.addMsgContent(componentField);
                System.out.println(prefix + "\t " + this.allFields.get(tagText).getFieldName());
                continue;
            }
            if (this.allComponents.containsKey(tagText)) {
                this.addComponentMsgContent(this.allComponents.get(tagText), prefix + "\t");
                ComponentComponent componentComponent = new ComponentComponent(this.allComponents.get(tagText), reqd);
                component.addMsgContent(componentComponent);
                System.out.println(prefix + "\t " + this.allComponents.get(tagText).getName());
                continue;
            }
            System.err.println("Could not find tagText: " + tagText);
        }
    }

    private List<?> getMsgContents(String msgID) {
        List nodes = this.msgContents.selectNodes("//dataroot/MsgContents[MsgID=" + msgID + "]");
        nodes.sort(new MsgContentNodeComparator());
        return nodes;
    }

    class EnumNodeComparator
    implements Comparator<Object> {
        EnumNodeComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            try {
                double pos1 = Double.parseDouble(Repository.this.getSingleNodeTextSafe((Node)o1, "Sort"));
                double pos2 = Double.parseDouble(Repository.this.getSingleNodeTextSafe((Node)o2, "Sort"));
                return Double.compare(pos1, pos2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    class MsgContentNodeComparator
    implements Comparator<Object> {
        MsgContentNodeComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            try {
                double pos1 = Double.parseDouble(Repository.this.getSingleNodeTextSafe((Node)o1, "Position"));
                double pos2 = Double.parseDouble(Repository.this.getSingleNodeTextSafe((Node)o2, "Position"));
                return Double.compare(pos1, pos2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

