/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class FileCopy {
    public static void fromTo(final File ramlDirectory, final File schemaRepository) throws IOException {
        Files.walkFileTree(ramlDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(schemaRepository.toPath().resolve(ramlDirectory.toPath().relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, schemaRepository.toPath().resolve(ramlDirectory.toPath().relativize(file)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

