/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import java.util.HashMap;
import java.util.Map;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.NoopAnnotator;
import org.jsonschema2pojo.rules.RuleFactory;
import org.raml.jaxrs.generator.GenerationException;

class RamlToJaxRSGenerationConfig
extends DefaultGenerationConfig {
    private AnnotationStyle jsonMapper;
    private Map<String, String> jsonMapperConfiguration = new HashMap<String, String>();

    public RamlToJaxRSGenerationConfig(AnnotationStyle jsonMapper, Map<String, String> jsonMapperConfiguration) {
        this.jsonMapper = jsonMapper;
        this.jsonMapperConfiguration = jsonMapperConfiguration;
    }

    public AnnotationStyle getAnnotationStyle() {
        return this.jsonMapper;
    }

    public boolean isIncludeJsr303Annotations() {
        return this.getConfiguredValue("isIncludeJsr303Annotations", false);
    }

    public boolean isUseCommonsLang3() {
        return this.getConfiguredValue("useCommonsLang3", false);
    }

    public boolean isGenerateBuilders() {
        return this.getConfiguredValue("generateBuilders", true);
    }

    public boolean isIncludeHashcodeAndEquals() {
        return this.getConfiguredValue("includeHashcodeAndEquals", false);
    }

    public Class<? extends Annotator> getCustomAnnotator() {
        String className = this.getConfiguredValueStr("customAnnotator", null);
        if (className == null) {
            return NoopAnnotator.class;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new GenerationException(e);
        }
    }

    public boolean isIncludeToString() {
        return this.getConfiguredValue("includeToString", false);
    }

    public boolean isUseLongIntegers() {
        return this.getConfiguredValue("useLongIntegers", false);
    }

    public boolean isIncludeConstructors() {
        return this.getConfiguredValue("includeConstructors", super.isIncludeConstructors());
    }

    public boolean isConstructorsRequiredPropertiesOnly() {
        return this.getConfiguredValue("constructorsRequiredPropertiesOnly", super.isConstructorsRequiredPropertiesOnly());
    }

    public boolean isIncludeAccessors() {
        return this.getConfiguredValue("includeAccessors", super.isIncludeAccessors());
    }

    public boolean isUseJodaDates() {
        return this.getConfiguredValue("useJodaDates", false);
    }

    public boolean isUseJodaLocalDates() {
        return this.getConfiguredValue("useJodaLocalDates", false);
    }

    public boolean isUseJodaLocalTimes() {
        return this.getConfiguredValue("useJodaLocalTimes", false);
    }

    public String getDateTimeType() {
        return this.getConfiguredValueStr("dateTimeType", null);
    }

    public String getDateType() {
        return this.getConfiguredValueStr("dateType", null);
    }

    public String getTimeType() {
        return this.getConfiguredValueStr("timeType", null);
    }

    public boolean isUsePrimitives() {
        return this.getConfiguredValue("usePrimitives", false);
    }

    public boolean isUseDoubleNumbers() {
        return this.getConfiguredValue("useDoubleNumbers", true);
    }

    public Class<? extends RuleFactory> getCustomRuleFactory() {
        String factory = this.getConfiguredValueStr("customRuleFactory", null);
        if (factory == null) {
            return RuleFactory.class;
        }
        try {
            return Class.forName(factory);
        }
        catch (ClassNotFoundException e) {
            throw new GenerationException(e);
        }
    }

    public String getOutputEncoding() {
        return this.getConfiguredValueStr("outputEncoding", "UTF-8");
    }

    public boolean isParcelable() {
        return this.getConfiguredValue("parcelable", false);
    }

    public boolean isSerializable() {
        return this.getConfiguredValue("serializable", false);
    }

    public boolean isInitializeCollections() {
        return this.getConfiguredValue("initializeCollections", true);
    }

    public String getClassNamePrefix() {
        return this.getConfiguredValueStr("classNamePrefix", "");
    }

    public String getClassNameSuffix() {
        return this.getConfiguredValueStr("classNameSuffix", "");
    }

    public boolean isUseBigIntegers() {
        return this.getConfiguredValue("useBigIntegers", false);
    }

    public boolean isUseBigDecimals() {
        return this.getConfiguredValue("useBigDecimals", false);
    }

    public boolean isIncludeAdditionalProperties() {
        return this.getConfiguredValue("includeAdditionalProperties", true);
    }

    public String getTargetVersion() {
        return this.getConfiguredValueStr("targetVersion", "1.6");
    }

    public boolean isIncludeDynamicAccessors() {
        return this.getConfiguredValue("includeDynamicAccessors", false);
    }

    private String getConfiguredValueStr(String key, String def) {
        if (this.jsonMapperConfiguration == null || this.jsonMapperConfiguration.isEmpty()) {
            return def;
        }
        String val = this.jsonMapperConfiguration.get(key);
        return val != null ? val : def;
    }

    private boolean getConfiguredValue(String key, boolean def) {
        if (this.jsonMapperConfiguration == null || this.jsonMapperConfiguration.isEmpty()) {
            return def;
        }
        String val = this.jsonMapperConfiguration.get(key);
        return val != null ? Boolean.parseBoolean(val) : def;
    }
}

