/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GRequest;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;

public class ResourceUtils {
    public static void fillInBodiesAndResponses(GResource resource, Multimap<GMethod, GRequest> incomingBodies, Multimap<GMethod, GResponse> responses) {
        for (GMethod method : resource.methods()) {
            if (method.body().size() == 0) {
                incomingBodies.put((Object)method, null);
            } else {
                for (GRequest typeDeclaration : method.body()) {
                    incomingBodies.put((Object)method, (Object)typeDeclaration);
                }
            }
            if (method.responses().size() == 0) {
                incomingBodies.put((Object)method, null);
                continue;
            }
            for (GResponse response : method.responses()) {
                responses.put((Object)method, (Object)response);
            }
        }
    }

    public static List<GParameter> accumulateUriParameters(GResource resource) {
        ImmutableSet<String> seenHere = ResourceUtils.extractSeen(new HashSet<String>(), resource);
        ArrayList<GParameter> parameters = new ArrayList<GParameter>();
        parameters.addAll(Lists.reverse((List)FluentIterable.from(resource.uriParameters()).toList()));
        while (resource.parentResource() != null) {
            resource = resource.parentResource();
            ImmutableSet<String> seenInParent = ResourceUtils.extractSeen(seenHere, resource);
            final ImmutableSet<String> finalSeenHere = seenHere;
            parameters.addAll(Lists.reverse((List)FluentIterable.from(resource.uriParameters()).filter((Predicate)new Predicate<GParameter>(){

                public boolean apply(@Nullable GParameter gParameter) {
                    return !finalSeenHere.contains(gParameter.name());
                }
            }).toList()));
            seenHere = seenInParent;
        }
        Collections.reverse(parameters);
        return parameters;
    }

    private static ImmutableSet<String> extractSeen(Set<String> seen, GResource resource) {
        return FluentIterable.from(resource.uriParameters()).transform((Function)new Function<GParameter, String>(){

            @Nullable
            public String apply(@Nullable GParameter gParameter) {
                return gParameter.name();
            }
        }).append(seen).toSet();
    }
}

