/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.ramltypes.GResponseType;
import org.raml.jaxrs.generator.v10.V10GResource;
import org.raml.jaxrs.generator.v10.V10GResponseType;
import org.raml.jaxrs.generator.v10.V10PGParameter;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;

public class V10GResponse
implements GResponse {
    private final Response response;
    private final List<GResponseType> bodies;
    private final List<GParameter> headers;

    public V10GResponse(final CurrentBuild currentBuild, final V10GResource v10GResource, final Method method, final Response response) {
        this.response = response;
        this.bodies = Lists.transform((List)this.response.body(), (Function)new Function<TypeDeclaration, GResponseType>(){

            @Nullable
            public GResponseType apply(@Nullable TypeDeclaration input) {
                return new V10GResponseType(input, currentBuild.fetchType(v10GResource.implementation(), method, response, input));
            }
        });
        this.headers = Lists.transform((List)response.headers(), (Function)new Function<TypeDeclaration, GParameter>(){

            @Nullable
            public GParameter apply(@Nullable TypeDeclaration input) {
                return new V10PGParameter(input, currentBuild.fetchType(input.type(), input));
            }
        });
    }

    public Response implementation() {
        return this.response;
    }

    @Override
    public List<GResponseType> body() {
        return this.bodies;
    }

    @Override
    public String code() {
        return this.response.code().value();
    }

    @Override
    public List<GParameter> headers() {
        return this.headers;
    }

    @Override
    public String getDescription() {
        return this.response.description() != null ? this.response.description().value() : null;
    }
}

