/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractJavaFileAssert<S extends AbstractJavaFileAssert<S, A>, A extends JavaFile>
extends AbstractObjectAssert<S, A> {
    protected AbstractJavaFileAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasFileComment(CodeBlock fileComment) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileComment of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CodeBlock actualFileComment = ((JavaFile)this.actual).fileComment;
        if (!Objects.areEqual((Object)actualFileComment, (Object)fileComment)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileComment, actualFileComment});
        }
        return (S)((Object)((AbstractJavaFileAssert)this.myself));
    }

    public S hasPackageName(String packageName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting packageName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPackageName = ((JavaFile)this.actual).packageName;
        if (!Objects.areEqual((Object)actualPackageName, (Object)packageName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, packageName, actualPackageName});
        }
        return (S)((Object)((AbstractJavaFileAssert)this.myself));
    }

    public S isSkipJavaLangImports() {
        this.isNotNull();
        if (!((JavaFile)this.actual).skipJavaLangImports) {
            this.failWithMessage("\nExpecting that actual JavaFile is skipJavaLangImports but is not.", new Object[0]);
        }
        return (S)((Object)((AbstractJavaFileAssert)this.myself));
    }

    public S isNotSkipJavaLangImports() {
        this.isNotNull();
        if (((JavaFile)this.actual).skipJavaLangImports) {
            this.failWithMessage("\nExpecting that actual JavaFile is not skipJavaLangImports but is.", new Object[0]);
        }
        return (S)((Object)((AbstractJavaFileAssert)this.myself));
    }

    public S hasTypeSpec(TypeSpec typeSpec) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting typeSpec of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        TypeSpec actualTypeSpec = ((JavaFile)this.actual).typeSpec;
        if (!Objects.areEqual((Object)actualTypeSpec, (Object)typeSpec)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, typeSpec, actualTypeSpec});
        }
        return (S)((Object)((AbstractJavaFileAssert)this.myself));
    }
}

