/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Collection;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractTypeSpecAssert<S extends AbstractTypeSpecAssert<S, A>, A extends TypeSpec>
extends AbstractObjectAssert<S, A> {
    protected AbstractTypeSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAnnotations(AnnotationSpec ... annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).annotations, (Object[])annotations);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasAnnotations(Collection<? extends AnnotationSpec> annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).annotations, annotations.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyAnnotations(AnnotationSpec ... annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).annotations, (Object[])annotations);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyAnnotations(Collection<? extends AnnotationSpec> annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).annotations, annotations.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveAnnotations(AnnotationSpec ... annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).annotations, (Object[])annotations);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveAnnotations(Collection<? extends AnnotationSpec> annotations) {
        this.isNotNull();
        if (annotations == null) {
            this.failWithMessage("Expecting annotations parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).annotations, annotations.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasNoAnnotations() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have annotations but had :\n  <%s>";
        if (((TypeSpec)this.actual).annotations.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((TypeSpec)this.actual).annotations});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasAnonymousTypeArguments(CodeBlock anonymousTypeArguments) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting anonymousTypeArguments of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CodeBlock actualAnonymousTypeArguments = ((TypeSpec)this.actual).anonymousTypeArguments;
        if (!Objects.areEqual((Object)actualAnonymousTypeArguments, (Object)anonymousTypeArguments)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, anonymousTypeArguments, actualAnonymousTypeArguments});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasEnumConstants(Map enumConstants) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting enumConstants of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map actualEnumConstants = ((TypeSpec)this.actual).enumConstants;
        if (!Objects.areEqual((Object)actualEnumConstants, (Object)enumConstants)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, enumConstants, actualEnumConstants});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasFieldSpecs(FieldSpec ... fieldSpecs) {
        this.isNotNull();
        if (fieldSpecs == null) {
            this.failWithMessage("Expecting fieldSpecs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).fieldSpecs, (Object[])fieldSpecs);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasFieldSpecs(Collection<? extends FieldSpec> fieldSpecs) {
        this.isNotNull();
        if (fieldSpecs == null) {
            this.failWithMessage("Expecting fieldSpecs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).fieldSpecs, fieldSpecs.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyFieldSpecs(FieldSpec ... fieldSpecs) {
        this.isNotNull();
        if (fieldSpecs == null) {
            this.failWithMessage("Expecting fieldSpecs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).fieldSpecs, (Object[])fieldSpecs);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyFieldSpecs(Collection<? extends FieldSpec> fieldSpecs) {
        this.isNotNull();
        if (fieldSpecs == null) {
            this.failWithMessage("Expecting fieldSpecs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).fieldSpecs, fieldSpecs.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveFieldSpecs(FieldSpec ... fieldSpecs) {
        this.isNotNull();
        if (fieldSpecs == null) {
            this.failWithMessage("Expecting fieldSpecs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).fieldSpecs, (Object[])fieldSpecs);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveFieldSpecs(Collection<? extends FieldSpec> fieldSpecs) {
        this.isNotNull();
        if (fieldSpecs == null) {
            this.failWithMessage("Expecting fieldSpecs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).fieldSpecs, fieldSpecs.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasNoFieldSpecs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have fieldSpecs but had :\n  <%s>";
        if (((TypeSpec)this.actual).fieldSpecs.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((TypeSpec)this.actual).fieldSpecs});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasInitializerBlock(CodeBlock initializerBlock) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting initializerBlock of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CodeBlock actualInitializerBlock = ((TypeSpec)this.actual).initializerBlock;
        if (!Objects.areEqual((Object)actualInitializerBlock, (Object)initializerBlock)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, initializerBlock, actualInitializerBlock});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasJavadoc(CodeBlock javadoc) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting javadoc of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CodeBlock actualJavadoc = ((TypeSpec)this.actual).javadoc;
        if (!Objects.areEqual((Object)actualJavadoc, (Object)javadoc)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, javadoc, actualJavadoc});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasKind(TypeSpec.Kind kind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        TypeSpec.Kind actualKind = ((TypeSpec)this.actual).kind;
        if (!Objects.areEqual((Object)actualKind, (Object)kind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, kind, actualKind});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasMethodSpecs(MethodSpec ... methodSpecs) {
        this.isNotNull();
        if (methodSpecs == null) {
            this.failWithMessage("Expecting methodSpecs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).methodSpecs, (Object[])methodSpecs);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasMethodSpecs(Collection<? extends MethodSpec> methodSpecs) {
        this.isNotNull();
        if (methodSpecs == null) {
            this.failWithMessage("Expecting methodSpecs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).methodSpecs, methodSpecs.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyMethodSpecs(MethodSpec ... methodSpecs) {
        this.isNotNull();
        if (methodSpecs == null) {
            this.failWithMessage("Expecting methodSpecs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).methodSpecs, (Object[])methodSpecs);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyMethodSpecs(Collection<? extends MethodSpec> methodSpecs) {
        this.isNotNull();
        if (methodSpecs == null) {
            this.failWithMessage("Expecting methodSpecs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).methodSpecs, methodSpecs.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveMethodSpecs(MethodSpec ... methodSpecs) {
        this.isNotNull();
        if (methodSpecs == null) {
            this.failWithMessage("Expecting methodSpecs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).methodSpecs, (Object[])methodSpecs);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveMethodSpecs(Collection<? extends MethodSpec> methodSpecs) {
        this.isNotNull();
        if (methodSpecs == null) {
            this.failWithMessage("Expecting methodSpecs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).methodSpecs, methodSpecs.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasNoMethodSpecs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have methodSpecs but had :\n  <%s>";
        if (((TypeSpec)this.actual).methodSpecs.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((TypeSpec)this.actual).methodSpecs});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasModifiers(Modifier ... modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).modifiers, (Object[])modifiers);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasModifiers(Collection<? extends Modifier> modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).modifiers, modifiers.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyModifiers(Modifier ... modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).modifiers, (Object[])modifiers);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyModifiers(Collection<? extends Modifier> modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).modifiers, modifiers.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveModifiers(Modifier ... modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).modifiers, (Object[])modifiers);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveModifiers(Collection<? extends Modifier> modifiers) {
        this.isNotNull();
        if (modifiers == null) {
            this.failWithMessage("Expecting modifiers parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).modifiers, modifiers.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasNoModifiers() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have modifiers but had :\n  <%s>";
        if (((TypeSpec)this.actual).modifiers.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((TypeSpec)this.actual).modifiers});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((TypeSpec)this.actual).name;
        if (!Objects.areEqual((Object)actualName, (Object)name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOriginatingElements(Element ... originatingElements) {
        this.isNotNull();
        if (originatingElements == null) {
            this.failWithMessage("Expecting originatingElements parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).originatingElements, (Object[])originatingElements);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOriginatingElements(Collection<? extends Element> originatingElements) {
        this.isNotNull();
        if (originatingElements == null) {
            this.failWithMessage("Expecting originatingElements parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).originatingElements, originatingElements.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyOriginatingElements(Element ... originatingElements) {
        this.isNotNull();
        if (originatingElements == null) {
            this.failWithMessage("Expecting originatingElements parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).originatingElements, (Object[])originatingElements);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyOriginatingElements(Collection<? extends Element> originatingElements) {
        this.isNotNull();
        if (originatingElements == null) {
            this.failWithMessage("Expecting originatingElements parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).originatingElements, originatingElements.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveOriginatingElements(Element ... originatingElements) {
        this.isNotNull();
        if (originatingElements == null) {
            this.failWithMessage("Expecting originatingElements parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).originatingElements, (Object[])originatingElements);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveOriginatingElements(Collection<? extends Element> originatingElements) {
        this.isNotNull();
        if (originatingElements == null) {
            this.failWithMessage("Expecting originatingElements parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).originatingElements, originatingElements.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasNoOriginatingElements() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have originatingElements but had :\n  <%s>";
        if (((TypeSpec)this.actual).originatingElements.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((TypeSpec)this.actual).originatingElements});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasStaticBlock(CodeBlock staticBlock) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting staticBlock of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CodeBlock actualStaticBlock = ((TypeSpec)this.actual).staticBlock;
        if (!Objects.areEqual((Object)actualStaticBlock, (Object)staticBlock)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, staticBlock, actualStaticBlock});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasSuperclass(TypeName superclass) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting superclass of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        TypeName actualSuperclass = ((TypeSpec)this.actual).superclass;
        if (!Objects.areEqual((Object)actualSuperclass, (Object)superclass)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, superclass, actualSuperclass});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasSuperinterfaces(TypeName ... superinterfaces) {
        this.isNotNull();
        if (superinterfaces == null) {
            this.failWithMessage("Expecting superinterfaces parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).superinterfaces, (Object[])superinterfaces);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasSuperinterfaces(Collection<? extends TypeName> superinterfaces) {
        this.isNotNull();
        if (superinterfaces == null) {
            this.failWithMessage("Expecting superinterfaces parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).superinterfaces, superinterfaces.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlySuperinterfaces(TypeName ... superinterfaces) {
        this.isNotNull();
        if (superinterfaces == null) {
            this.failWithMessage("Expecting superinterfaces parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).superinterfaces, (Object[])superinterfaces);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlySuperinterfaces(Collection<? extends TypeName> superinterfaces) {
        this.isNotNull();
        if (superinterfaces == null) {
            this.failWithMessage("Expecting superinterfaces parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).superinterfaces, superinterfaces.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveSuperinterfaces(TypeName ... superinterfaces) {
        this.isNotNull();
        if (superinterfaces == null) {
            this.failWithMessage("Expecting superinterfaces parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).superinterfaces, (Object[])superinterfaces);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveSuperinterfaces(Collection<? extends TypeName> superinterfaces) {
        this.isNotNull();
        if (superinterfaces == null) {
            this.failWithMessage("Expecting superinterfaces parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).superinterfaces, superinterfaces.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasNoSuperinterfaces() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have superinterfaces but had :\n  <%s>";
        if (((TypeSpec)this.actual).superinterfaces.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((TypeSpec)this.actual).superinterfaces});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasTypeSpecs(TypeSpec ... typeSpecs) {
        this.isNotNull();
        if (typeSpecs == null) {
            this.failWithMessage("Expecting typeSpecs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeSpecs, (Object[])typeSpecs);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasTypeSpecs(Collection<? extends TypeSpec> typeSpecs) {
        this.isNotNull();
        if (typeSpecs == null) {
            this.failWithMessage("Expecting typeSpecs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeSpecs, typeSpecs.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyTypeSpecs(TypeSpec ... typeSpecs) {
        this.isNotNull();
        if (typeSpecs == null) {
            this.failWithMessage("Expecting typeSpecs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeSpecs, (Object[])typeSpecs);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyTypeSpecs(Collection<? extends TypeSpec> typeSpecs) {
        this.isNotNull();
        if (typeSpecs == null) {
            this.failWithMessage("Expecting typeSpecs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeSpecs, typeSpecs.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveTypeSpecs(TypeSpec ... typeSpecs) {
        this.isNotNull();
        if (typeSpecs == null) {
            this.failWithMessage("Expecting typeSpecs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeSpecs, (Object[])typeSpecs);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveTypeSpecs(Collection<? extends TypeSpec> typeSpecs) {
        this.isNotNull();
        if (typeSpecs == null) {
            this.failWithMessage("Expecting typeSpecs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeSpecs, typeSpecs.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasNoTypeSpecs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have typeSpecs but had :\n  <%s>";
        if (((TypeSpec)this.actual).typeSpecs.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((TypeSpec)this.actual).typeSpecs});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasTypeVariables(TypeVariableName ... typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeVariables, (Object[])typeVariables);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasTypeVariables(Collection<? extends TypeVariableName> typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeVariables, typeVariables.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyTypeVariables(TypeVariableName ... typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeVariables, (Object[])typeVariables);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasOnlyTypeVariables(Collection<? extends TypeVariableName> typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeVariables, typeVariables.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveTypeVariables(TypeVariableName ... typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeVariables, (Object[])typeVariables);
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S doesNotHaveTypeVariables(Collection<? extends TypeVariableName> typeVariables) {
        this.isNotNull();
        if (typeVariables == null) {
            this.failWithMessage("Expecting typeVariables parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractTypeSpecAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((TypeSpec)this.actual).typeVariables, typeVariables.toArray());
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }

    public S hasNoTypeVariables() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have typeVariables but had :\n  <%s>";
        if (((TypeSpec)this.actual).typeVariables.iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((TypeSpec)this.actual).typeVariables});
        }
        return (S)((Object)((AbstractTypeSpecAssert)this.myself));
    }
}

