/*
 * Decompiled with CFR 0.152.
 */
package org.raml.testutils.matchers;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class AnnotationSpecMatchers {
    public static Matcher<AnnotationSpec> hasMember(final String member) {
        return new TypeSafeMatcher<AnnotationSpec>(){

            protected boolean matchesSafely(AnnotationSpec item) {
                return item.members.containsKey(member);
            }

            public void describeTo(Description description) {
                description.appendText("has member " + member);
            }
        };
    }

    public static Matcher<AnnotationSpec> member(final String member, Matcher<Iterable<? extends CodeBlock>> memberMatcher) {
        return new FeatureMatcher<AnnotationSpec, Iterable<? extends CodeBlock>>(memberMatcher, "member", "member"){

            protected Iterable<? extends CodeBlock> featureValueOf(AnnotationSpec actual) {
                return (Iterable)actual.members.get(member);
            }
        };
    }
}

