/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.reflext.api.AnnotationIntrospector;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.HierarchyVisitor;
import org.reflext.api.MethodInfo;
import org.reflext.api.MethodSignature;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassIntrospector {
    private final ClassTypeInfo type;

    public ClassIntrospector(ClassTypeInfo type) {
        this.type = type;
    }

    public <A extends Annotation> Collection<MethodInfo> resolveMethods(Class<A> annotationClass) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        AnnotationIntrospector<A> introspector = new AnnotationIntrospector<A>(annotationClass);
        for (MethodInfo method : this.getMethods()) {
            if (introspector.resolve(method) == null) continue;
            methods.add(method);
        }
        return methods;
    }

    public Map<String, MethodInfo> getGetterMap() {
        HashMap<String, MethodInfo> getterMap = new HashMap<String, MethodInfo>();
        for (MethodInfo getter : this.getGetters()) {
            String getterName = getter.getName();
            String name = getterName.startsWith("get") ? Introspector.decapitalize(getterName.substring(3)) : Introspector.decapitalize(getterName.substring(2));
            getterMap.put(name, getter);
        }
        return getterMap;
    }

    public Iterable<MethodInfo> getGetters() {
        final MethodContainer getters = new MethodContainer();
        HierarchyVisitor visitor = new HierarchyVisitor(){

            public boolean enter(ClassTypeInfo type) {
                return true;
            }

            public void leave(ClassTypeInfo type) {
                if (!type.getName().equals(Object.class.getName())) {
                    for (MethodInfo method : type.getDeclaredMethods()) {
                        String methodName = method.getName();
                        if (!methodName.startsWith("get") || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3)) || method.getParameterTypes().size() != 0) continue;
                        getters.add(method);
                    }
                }
            }
        };
        this.type.accept(visitor);
        return getters;
    }

    public Map<String, Set<MethodInfo>> getSetterMap() {
        HashMap<String, Set<MethodInfo>> setterMap = new HashMap<String, Set<MethodInfo>>();
        for (MethodInfo setter : this.getSetters()) {
            String name = Introspector.decapitalize(setter.getName().substring(3));
            HashSet<MethodInfo> setters = (HashSet<MethodInfo>)setterMap.get(name);
            if (setters == null) {
                setters = new HashSet<MethodInfo>();
                setterMap.put(name, setters);
            }
            setters.add(setter);
        }
        return setterMap;
    }

    public Iterable<MethodInfo> getSetters() {
        final MethodContainer setters = new MethodContainer();
        HierarchyVisitor visitor = new HierarchyVisitor(){

            public boolean enter(ClassTypeInfo type) {
                return true;
            }

            public void leave(ClassTypeInfo type) {
                if (!type.getName().equals(Object.class.getName())) {
                    for (MethodInfo method : type.getDeclaredMethods()) {
                        String methodName = method.getName();
                        if (!methodName.startsWith("set") || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3)) || method.getParameterTypes().size() != 1) continue;
                        setters.add(method);
                    }
                }
            }
        };
        this.type.accept(visitor);
        return setters;
    }

    public Iterable<MethodInfo> getMethods() {
        return ClassIntrospector.getMethods(this.type);
    }

    private static MethodContainer getMethods(TypeInfo type) {
        if (type instanceof ClassTypeInfo) {
            return ClassIntrospector.getMethods((ClassTypeInfo)type);
        }
        if (type instanceof ParameterizedTypeInfo) {
            return ClassIntrospector.getMethods(((ParameterizedTypeInfo)type).getRawType());
        }
        throw new UnsupportedOperationException("Cannot get methods from type " + type);
    }

    private static MethodContainer getMethods(ClassTypeInfo clazz) {
        TypeInfo superType = clazz.getSuperType();
        MethodContainer methods = superType == null || superType instanceof ClassTypeInfo && ((ClassTypeInfo)superType).getName().equals(Object.class.getName()) ? new MethodContainer() : ClassIntrospector.getMethods(superType);
        for (TypeInfo interfaceType : clazz.getInterfaces()) {
            methods.addAll(ClassIntrospector.getMethods(interfaceType));
        }
        for (MethodInfo declaredMethod : clazz.getDeclaredMethods()) {
            methods.add(declaredMethod);
        }
        return methods;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodContainer
    implements Iterable<MethodInfo> {
        private final Map<MethodSignature, MethodInfo> map = new HashMap<MethodSignature, MethodInfo>();

        private MethodContainer() {
        }

        public void addAll(Iterable<MethodInfo> methods) {
            for (MethodInfo method : methods) {
                this.add(method);
            }
        }

        public boolean add(MethodInfo method) {
            MethodSignature key = method.getSignature();
            MethodInfo existing = this.map.get(key);
            if (existing != null) {
                if (method.getReturnType().isCovariantWith(existing.getReturnType()) && existing.getOwner().isAssignableFrom(method.getOwner())) {
                    this.map.put(key, method);
                    return true;
                }
            } else {
                this.map.put(key, method);
                return true;
            }
            return false;
        }

        @Override
        public Iterator<MethodInfo> iterator() {
            return this.map.values().iterator();
        }
    }
}

