/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.api.introspection;

import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class MethodIntrospector {

  /** . */
  private final TypeScope typeScope;

  public MethodIntrospector(TypeScope typeScope) {
    this.typeScope = typeScope;
  }

  public Iterable<MethodInfo> getMethods(TypeInfo type) {
    return findMethods(type);
  }

  private MethodContainer findMethods(TypeInfo type) {
    if (type instanceof ClassTypeInfo) {
      return findMethods((ClassTypeInfo)type);
    } else if (type instanceof ParameterizedTypeInfo) {
      return findMethods(((ParameterizedTypeInfo)type).getRawType());
    } else {
      throw new UnsupportedOperationException("Cannot get methods from type " + type);
    }
  }

  private MethodContainer findMethods(ClassTypeInfo clazz) {
    MethodContainer  methods;
    if (typeScope == TypeScope.CLASS) {
      methods = new MethodContainer();
    } else {
      TypeInfo superType = clazz.getSuperType();
      if (superType == null || (superType instanceof ClassTypeInfo && ((ClassTypeInfo)superType).getName().equals(Object.class.getName()))) {
        methods = new MethodContainer();
      } else {
        methods = findMethods(superType);
      }
    }

    //
    if (typeScope == TypeScope.CLASS_AND_INTERFACE_HIERARCHY) {
      for (TypeInfo interfaceType : clazz.getInterfaces()) {
        methods.addAll(findMethods(interfaceType));
      }
    }

    //
    for (MethodInfo declaredMethod : clazz.getDeclaredMethods()) {
      methods.add(declaredMethod);
    }

    //
    return methods;
  }
}
