/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.api;

import java.lang.annotation.Annotation;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class AnnotationIntrospector<A extends Annotation> {

  /** . */
  private final Class<A> annotationClass;

  public AnnotationIntrospector(Class<A> annotationClass) {
    if (annotationClass == null) {
      throw new NullPointerException();
    }

    //
    this.annotationClass = annotationClass;
  }

  private class Blah implements HierarchyVisitor {

    A annotation;

    public boolean enter(ClassTypeInfo type) {
      annotation = type.getDeclaredAnnotation(annotationClass);
      return annotation == null;
    }

    public void leave(ClassTypeInfo type) {
    }
  }

  public A resolve(ClassTypeInfo annotatedType) {
    Blah blah = new Blah();
    VisitorStrategy.Hierarchy<Blah> strategy = new VisitorStrategy.Hierarchy<Blah>();
    strategy.accept(annotatedType, blah);
    return blah.annotation;
  }

  private class Bluh implements HierarchyVisitor {

    /** . */
    private final MethodSignature methodSignature;

    private Bluh(MethodSignature methodSignature) {
      this.methodSignature = methodSignature;
    }

    A annotation;

    public boolean enter(ClassTypeInfo type) {
      MethodInfo m = type.getDeclaredMethod(methodSignature);
      if (m != null) {
        annotation = m.getDeclaredAnnotation(annotationClass);
      }
      return annotation == null;
    }

    public void leave(ClassTypeInfo type) {
    }
  }

  public A resolve(MethodInfo method) {
    return resolve(method.getOwner(), method.getSignature());
  }

  public  A resolve(ClassTypeInfo declaringType, MethodSignature methodSignature) {
    Bluh bluh = new Bluh(methodSignature);
    VisitorStrategy.Hierarchy<Bluh> strategy = new VisitorStrategy.Hierarchy<Bluh>();
    strategy.accept(declaringType, bluh);
    return bluh.annotation;
  }
}
