/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.api.introspection;

import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.HierarchyVisitor;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
abstract class AbstractPropertyHierarchyVisitor implements HierarchyVisitor {

  /** . */
  private final HierarchyScope hierarchyScope;

  /** . */
  private final ClassTypeInfo baseType;

  public AbstractPropertyHierarchyVisitor(ClassTypeInfo baseType, HierarchyScope hierarchyScope) {
    this.baseType = baseType;
    this.hierarchyScope = hierarchyScope;
  }

  public boolean enter(ClassTypeInfo type) {
    if (type.getName().equals(Object.class.getName())) {
      return false;
    } else if (type == baseType) {
      return true;
    } else {
      switch (hierarchyScope) {
        case ALL:
          return true;
        case ANCESTORS:
          return type.getKind() == ClassKind.CLASS;
        case CLASS:
          return false;
        default:
          throw new AssertionError();
      }
    }
  }
}
