/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api.introspection;

import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.HierarchyVisitor;
import org.reflext.api.introspection.HierarchyScope;

abstract class AbstractPropertyHierarchyVisitor
implements HierarchyVisitor {
    private final HierarchyScope hierarchyScope;
    private final ClassTypeInfo baseType;

    public AbstractPropertyHierarchyVisitor(ClassTypeInfo baseType, HierarchyScope hierarchyScope) {
        this.baseType = baseType;
        this.hierarchyScope = hierarchyScope;
    }

    public boolean enter(ClassTypeInfo type) {
        if (type.getName().equals(Object.class.getName())) {
            return false;
        }
        if (type == this.baseType) {
            return true;
        }
        switch (this.hierarchyScope) {
            case ALL: {
                return true;
            }
            case ANCESTORS: {
                return type.getKind() == ClassKind.CLASS;
            }
            case CLASS: {
                return false;
            }
        }
        throw new AssertionError();
    }
}

