/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.api.visit;

import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public enum HierarchyScope {

  CLASS() {
    @Override
    public <V extends HierarchyVisitor<V>> HierarchyVisitorStrategy<V> get() {
      return new HierarchyVisitorStrategy<V>() {
        boolean done = false;
        @Override
        protected boolean accept(ClassTypeInfo type) {
          if (done) {
            return false;
          } else {
            done = true;
            return true;
          }
        }
      };
    }},

  ANCESTORS() {
    @Override
    public <V extends HierarchyVisitor<V>> HierarchyVisitorStrategy<V> get() {
      @SuppressWarnings("unchecked")
      HierarchyVisitorStrategy<V> tmp = ancestors;
      return tmp;
    }},

  ALL() {
    @Override
    public <V extends HierarchyVisitor<V>> HierarchyVisitorStrategy<V> get() {
      @SuppressWarnings("unchecked")
      HierarchyVisitorStrategy tmp = all;
      return tmp;
    }}

  ;

  /** . */
  private static final HierarchyVisitorStrategy ancestors = new HierarchyVisitorStrategy() {
    @Override
    boolean accept(ClassTypeInfo type) {
      return type.getKind() == ClassKind.CLASS;
    }
  };

  /** . */
  private static final HierarchyVisitorStrategy all = new HierarchyVisitorStrategy() {
    @Override
    boolean accept(ClassTypeInfo type) {
      return true;
    }
  };


  public abstract <V extends HierarchyVisitor<V>> HierarchyVisitorStrategy<V> get();

}
