/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api.introspection;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.api.introspection.AbstractScopedHierarchyVisitor;
import org.reflext.api.introspection.AnnotationIntrospector;
import org.reflext.api.introspection.AnnotationTarget;
import org.reflext.api.introspection.MethodContainer;
import org.reflext.api.visit.HierarchyScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodIntrospector {
    private final HierarchyScope hierarchyScope;
    private final boolean removeOverrides;

    public MethodIntrospector(HierarchyScope hierarchyScope, boolean removeOverrides) throws NullPointerException {
        if (hierarchyScope == null) {
            throw new NullPointerException();
        }
        this.hierarchyScope = hierarchyScope;
        this.removeOverrides = removeOverrides;
    }

    public MethodIntrospector(HierarchyScope hierarchyScope) throws NullPointerException {
        this(hierarchyScope, false);
    }

    public <A> Collection<AnnotationTarget<MethodInfo, A>> resolveMethods(ClassTypeInfo cti, AnnotationType<A, ?> annotationClass) {
        ArrayList<AnnotationTarget<MethodInfo, A>> methods = new ArrayList<AnnotationTarget<MethodInfo, A>>();
        AnnotationIntrospector<A> introspector = new AnnotationIntrospector<A>(annotationClass);
        for (MethodInfo method : this.getMethods(cti)) {
            A annotation = introspector.resolve(method);
            if (annotation == null) continue;
            methods.add(new AnnotationTarget<MethodInfo, A>(method, annotation));
        }
        return methods;
    }

    public Map<String, MethodInfo> getGetterMap(ClassTypeInfo classTypeInfo) throws NullPointerException {
        if (classTypeInfo == null) {
            throw new NullPointerException();
        }
        HashMap<String, MethodInfo> getterMap = new HashMap<String, MethodInfo>();
        for (MethodInfo getter : this.getGetters(classTypeInfo)) {
            String getterName = getter.getName();
            String name = getterName.startsWith("get") ? Introspector.decapitalize(getterName.substring(3)) : Introspector.decapitalize(getterName.substring(2));
            getterMap.put(name, getter);
        }
        return getterMap;
    }

    public Iterable<MethodInfo> getGetters(ClassTypeInfo classTypeInfo) throws NullPointerException {
        if (classTypeInfo == null) {
            throw new NullPointerException();
        }
        final MethodContainer getters = new MethodContainer();
        AbstractScopedHierarchyVisitor visitor = new AbstractScopedHierarchyVisitor(classTypeInfo){

            public void leave(ClassTypeInfo type) {
                if (!type.getName().equals(Object.class.getName())) {
                    for (MethodInfo method : type.getDeclaredMethods()) {
                        String methodName = method.getName();
                        if ((!methodName.startsWith("get") || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3))) && (!methodName.startsWith("is") || methodName.length() <= 2 || !Character.isUpperCase(methodName.charAt(2))) || method.getParameterTypes().size() != 0) continue;
                        getters.add(method);
                    }
                }
            }
        };
        classTypeInfo.accept(this.hierarchyScope.get(), (AbstractScopedHierarchyVisitor)visitor);
        return getters;
    }

    public Map<String, Set<MethodInfo>> getSetterMap(ClassTypeInfo classTypeInfo) throws NullPointerException {
        HashMap<String, Set<MethodInfo>> setterMap = new HashMap<String, Set<MethodInfo>>();
        for (MethodInfo setter : this.getSetters(classTypeInfo)) {
            String name = Introspector.decapitalize(setter.getName().substring(3));
            HashSet<MethodInfo> setters = (HashSet<MethodInfo>)setterMap.get(name);
            if (setters == null) {
                setters = new HashSet<MethodInfo>();
                setterMap.put(name, setters);
            }
            setters.add(setter);
        }
        return setterMap;
    }

    public Iterable<MethodInfo> getSetters(ClassTypeInfo classTypeInfo) {
        if (classTypeInfo == null) {
            throw new NullPointerException();
        }
        final MethodContainer setters = new MethodContainer();
        AbstractScopedHierarchyVisitor visitor = new AbstractScopedHierarchyVisitor(classTypeInfo){

            public void leave(ClassTypeInfo type) {
                if (!type.getName().equals(Object.class.getName())) {
                    for (MethodInfo method : type.getDeclaredMethods()) {
                        String methodName = method.getName();
                        if (!methodName.startsWith("set") || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3)) || method.getParameterTypes().size() != 1) continue;
                        setters.add(method);
                    }
                }
            }
        };
        classTypeInfo.accept(this.hierarchyScope.get(), (AbstractScopedHierarchyVisitor)visitor);
        return setters;
    }

    public Set<MethodInfo> getMethods(TypeInfo typeInfo) throws NullPointerException {
        if (typeInfo == null) {
            throw new NullPointerException();
        }
        MethodContainer container = this.removeOverrides ? new MethodContainer((ClassTypeInfo)typeInfo) : new MethodContainer();
        this.findMethods(typeInfo, container);
        return container.toCollection();
    }

    private void findMethods(TypeInfo ti, MethodContainer container) {
        if (ti instanceof ClassTypeInfo) {
            this.findMethods((ClassTypeInfo)ti, container);
        } else if (ti instanceof ParameterizedTypeInfo) {
            this.findMethods(((ParameterizedTypeInfo)ti).getRawType(), container);
        } else {
            throw new UnsupportedOperationException("Cannot get methods from type " + ti);
        }
    }

    private void findMethods(ClassTypeInfo clazz, MethodContainer container) {
        TypeInfo superType;
        if (!(this.hierarchyScope == HierarchyScope.CLASS || (superType = clazz.getSuperType()) == null || superType instanceof ClassTypeInfo && ((ClassTypeInfo)superType).getName().equals(Object.class.getName()))) {
            this.findMethods(superType, container);
        }
        if (this.hierarchyScope == HierarchyScope.ALL) {
            for (TypeInfo interfaceType : clazz.getInterfaces()) {
                this.findMethods(interfaceType, container);
            }
        }
        for (MethodInfo declaredMethod : clazz.getDeclaredMethods()) {
            container.add(declaredMethod);
        }
    }
}

