/*
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.api.visit;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.VisitorStrategy;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public abstract class HierarchyVisitorStrategy<V extends HierarchyVisitor<V>> implements VisitorStrategy<V, HierarchyVisitorStrategy<V>> {

  public final void visit(TypeInfo type, V visitor) {
    if (type instanceof ClassTypeInfo) {
      ClassTypeInfo classType = (ClassTypeInfo)type;
      if (accept(classType)) {
        if (visitor.enter(classType)) {
          TypeInfo superType = classType.getSuperType();
          if (superType != null) {
            visit(superType, visitor);
          }
          for (TypeInfo implementedInterface : classType.getInterfaces()) {
            visit(implementedInterface, visitor);
          }
          visitor.leave(classType);
        }
      }
    } else if (type instanceof ParameterizedTypeInfo) {
      visit(((ParameterizedTypeInfo)type).getRawType(), visitor);
    } else {
    }
  }

  abstract boolean accept(ClassTypeInfo type);
}
