/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.apt;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import org.reflext.api.AccessScope;
import org.reflext.spi.model.MethodModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaxLangMethodModel
implements MethodModel<Object, ExecutableElement> {
    public Iterable<ExecutableElement> getDeclaredMethods(Object classType) {
        if (classType instanceof TypeElement) {
            TypeElement typeElt = (TypeElement)classType;
            return ElementFilter.methodsIn(typeElt.getEnclosedElements());
        }
        return this.getDeclaredMethods(((DeclaredType)classType).asElement());
    }

    public String getName(ExecutableElement executableElement) {
        return executableElement.getSimpleName().toString();
    }

    public Object getReturnType(ExecutableElement executableElement) {
        return executableElement.getReturnType();
    }

    public Iterable<Object> getParameterTypes(ExecutableElement executableElement) {
        ExecutableType executableType = (ExecutableType)executableElement.asType();
        ArrayList<Object> parameterTypes = new ArrayList<Object>();
        for (TypeMirror typeMirror : executableType.getParameterTypes()) {
            parameterTypes.add(typeMirror);
        }
        return parameterTypes;
    }

    public AccessScope getAccess(ExecutableElement executableElement) {
        Set<Modifier> modifiers = executableElement.getModifiers();
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return AccessScope.PUBLIC;
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return AccessScope.PRIVATE;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return AccessScope.PROTECTED;
        }
        return AccessScope.PACKAGE_PROTECTED;
    }

    public Iterable<Object> getTypeParameters(ExecutableElement executableElement) {
        ArrayList<Object> typeParameters = new ArrayList<Object>();
        for (TypeParameterElement typeParameterElement : executableElement.getTypeParameters()) {
            typeParameters.add(typeParameterElement.asType());
        }
        return typeParameters;
    }

    public ExecutableElement getGenericDeclaration(Object typeVariable) {
        return (ExecutableElement)((TypeParameterElement)((TypeVariable)typeVariable).asElement()).getGenericElement();
    }

    public Object getOwner(ExecutableElement executableElement) {
        return executableElement.getEnclosingElement();
    }

    public boolean isAbstract(ExecutableElement executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isStatic(ExecutableElement executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    public boolean isFinal(ExecutableElement executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.FINAL);
    }

    public <A extends Annotation> A getDeclaredAnnotation(ExecutableElement method, Class<A> annotationClass) {
        return method.getAnnotation(annotationClass);
    }
}

