/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.apt;

import org.reflext.spi.model.AnnotationModel;

import javax.lang.model.element.*;
import javax.lang.model.util.ElementFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public abstract class JavaxLangAnnotationModel<E> implements AnnotationModel<Object, E, AnnotationMirror, ExecutableElement> {
  @Override
  public Object getAnnotationType(AnnotationMirror annotationMirror) {
    return annotationMirror.getAnnotationType();
  }

  @Override
  public Collection<ExecutableElement> getAnnotationParameters(AnnotationMirror annotation) {
    return ElementFilter.methodsIn(annotation.getAnnotationType().asElement().getEnclosedElements());
  }

  @Override
  public String getAnnotationParameterName(ExecutableElement parameter) {
    return parameter.getSimpleName().toString();
  }

  @Override
  public Object getAnnotationParameterType(ExecutableElement parameter) {
    return parameter.getReturnType();
  }

  @Override
  public List<?> getAnnotationParameterValue(AnnotationMirror annotation, ExecutableElement parameter) {
    AnnotationValue annotationValue = annotation.getElementValues().get(parameter);
    if (annotationValue == null) {
      throw new UnsupportedOperationException();
    } else {
      Object value = annotationValue.getValue();
      if (value instanceof List) {
        List list = new ArrayList((List)value);
        for (int i = 0;i < list.size();i++) {
          list.set(i, unwrap(list.get(i)));
        }
        return list;
      } else {
        return Arrays.asList(unwrap(value));
      }
    }
  }

  private Object unwrap(Object o) {
    if (o instanceof VariableElement) {
      return ((VariableElement)o).getSimpleName().toString();
    } else if (o instanceof AnnotationValue) {
      return ((AnnotationValue)o).getValue();
    } else {
      return o;
    }
  }
}
