/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.apt;

import org.reflext.spi.model.MethodModel;
import org.reflext.api.AccessScope;

import javax.lang.model.element.*;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class JavaxLangMethodModel implements MethodModel<Object, ExecutableElement> {

  public Iterable<ExecutableElement> getDeclaredMethods(Object classType) {
    if (classType instanceof TypeElement) {
      TypeElement typeElt = (TypeElement)classType;
      return ElementFilter.methodsIn(typeElt.getEnclosedElements());
    } else {
      return getDeclaredMethods(((DeclaredType)classType).asElement());
    }
  }

  public String getName(ExecutableElement executableElement) {
    return executableElement.getSimpleName().toString();
  }

  public Object getReturnType(ExecutableElement executableElement) {
    return executableElement.getReturnType();
  }

  public Iterable<Object> getParameterTypes(ExecutableElement executableElement) {
    ExecutableType executableType = (ExecutableType)executableElement.asType();
    List<Object> parameterTypes = new ArrayList<Object>();
    for (TypeMirror parameterType : executableType.getParameterTypes()) {
      parameterTypes.add(parameterType);
    }
    return parameterTypes;
  }

  @Override
  public Iterable<String> getParameterNames(ExecutableElement executableElement) {
    List<String> names = new ArrayList<String>();
    for (VariableElement elt : executableElement.getParameters()) {
      names.add(elt.getSimpleName().toString());
    }
    return names;
  }

  public AccessScope getAccess(ExecutableElement executableElement) {
    return JavaxLangReflectionModel.getAccess(executableElement);
  }

  public Iterable<Object> getTypeParameters(ExecutableElement executableElement) {
    List<Object> typeParameters = new ArrayList<Object>();
    for (TypeParameterElement typeParameterElt : executableElement.getTypeParameters()) {
      typeParameters.add(typeParameterElt.asType());
    }
    return typeParameters;
  }

  public ExecutableElement getGenericDeclaration(Object typeVariable) {
    return (ExecutableElement)((TypeParameterElement)((TypeVariable)typeVariable).asElement()).getGenericElement();
  }

  public Object getOwner(ExecutableElement executableElement) {
    return executableElement.getEnclosingElement();
  }

  public boolean isAbstract(ExecutableElement executableElement) {
    return JavaxLangReflectionModel.isAbstract(executableElement);
  }

  public boolean isStatic(ExecutableElement executableElement) {
    return JavaxLangReflectionModel.isStatic(executableElement);
  }

  public boolean isNative(ExecutableElement executableElement) {
    return JavaxLangReflectionModel.isNative(executableElement);
  }

  public boolean isFinal(ExecutableElement executableElement) {
    return JavaxLangReflectionModel.isFinal(executableElement);
  }
}
