/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.builder;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.FieldInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeResolver;
import org.reflext.apt.JavaxLangReflectionModel;
import org.reflext.core.TypeResolverImpl;

import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 */
@SupportedSourceVersion(SourceVersion.RELEASE_5)
@SupportedAnnotationTypes("org.reflext.builder.Builder")
public class BuilderProcessor extends AbstractProcessor {

  @Override
  public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {




    TypeResolver resolver = TypeResolverImpl.create(new JavaxLangReflectionModel(), false);

    Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Builder.class);
    for (Element element : elements) {
      if (element instanceof TypeElement) {
        TypeElement te = (TypeElement)element;
        TypeInfo ti = resolver.resolve(te);
        if (ti instanceof ClassTypeInfo) {
          ClassTypeInfo cti = (ClassTypeInfo)ti;
          try {
            generate(cti);
          }
          catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
          }
        }
      }
    }
    return false;
  }

  private void generate(ClassTypeInfo cti) throws IOException {
    BuilderDescriptor desc = new BuilderDescriptor(cti);
    Filer filer = processingEnv.getFiler();
    JavaFileObject jfo = filer.createSourceFile(desc.getClassName(), (Element)cti.unwrap());


    StringWriter sw = new StringWriter();
    desc.writeTo(sw);
    System.out.println("sw = " + sw);

    Writer out = jfo.openWriter();
    try {
      desc.writeTo(out);
    }
    finally {
      try {
        out.close();
      }
      catch (IOException ignore) {
      }
    }
  }
}
