/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.MethodSignature;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.core.MethodInfoImpl;
import org.reflext.core.TypeDomain;
import org.reflext.core.TypeInfoImpl;
import org.reflext.core.TypeVariableInfoImpl;
import org.reflext.core.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassTypeInfoImpl<T, M>
extends TypeInfoImpl<T, M>
implements ClassTypeInfo {
    private final T classType;
    private final String className;
    private List<TypeInfo> interfaces;
    private TypeInfo superType;
    private boolean superClassResolved;
    private List<TypeVariableInfo> typeParameters;
    private List<MethodInfo> methods;
    private final String simpleName;
    private final String packageName;
    private final ClassKind kind;

    public ClassTypeInfoImpl(TypeDomain<T, M> domain, T classType) {
        super(domain);
        String packageName;
        String simpleName;
        String className = domain.typeModel.getClassName(classType);
        int index = className.lastIndexOf(46);
        if (index == -1) {
            simpleName = className;
            packageName = "";
        } else {
            simpleName = className.substring(index + 1);
            packageName = className.substring(0, index);
        }
        ClassKind kind = domain.typeModel.getClassKind(classType);
        this.className = className;
        this.classType = classType;
        this.interfaces = null;
        this.superType = null;
        this.superClassResolved = false;
        this.simpleName = simpleName;
        this.packageName = packageName;
        this.kind = kind;
    }

    public String getName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public ClassKind getKind() {
        return this.kind;
    }

    public List<TypeVariableInfo> getTypeParameters() {
        if (this.typeParameters == null) {
            ArrayList<TypeVariableInfo> typeParameters = new ArrayList<TypeVariableInfo>();
            for (Object tv : this.domain.typeModel.getTypeParameters(this.classType)) {
                TypeVariableInfoImpl typeParameter = (TypeVariableInfoImpl)this.domain._getType(tv);
                typeParameters.add(typeParameter);
            }
            this.typeParameters = typeParameters;
        }
        return this.typeParameters;
    }

    public Iterable<TypeInfo> getInterfaces() {
        if (this.interfaces == null) {
            ArrayList<TypeInfo> interfaces = new ArrayList<TypeInfo>();
            for (Object interfaceType : this.domain.typeModel.getInterfaces(this.classType)) {
                TypeInfo itf = this.domain.getType(interfaceType);
                interfaces.add(itf);
            }
            this.interfaces = interfaces;
        }
        return this.interfaces;
    }

    public TypeInfo getSuperType() {
        if (!this.superClassResolved) {
            Object superClassType = this.domain.typeModel.getSuperClass(this.classType);
            if (superClassType != null) {
                this.superType = this.domain.getType(superClassType);
            }
            this.superClassResolved = true;
        }
        return this.superType;
    }

    public TypeInfo resolve(TypeInfo type) {
        return Utils.resolve((ClassTypeInfo)this, type);
    }

    public List<MethodInfo> getDeclaredMethods() {
        if (this.methods == null) {
            ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
            for (Object method : this.domain.methodModel.getDeclaredMethods(this.classType)) {
                MethodInfoImpl mi = new MethodInfoImpl(this, this.domain, method);
                methods.add(mi);
            }
            this.methods = methods;
        }
        return this.methods;
    }

    public MethodInfo getDeclaredMethod(MethodSignature methodSignature) {
        for (MethodInfo methodInfo : this.getDeclaredMethods()) {
            if (!methodInfo.getSignature().equals((Object)methodSignature)) continue;
            return methodInfo;
        }
        return null;
    }

    private boolean isAssignableFrom(TypeInfo that) {
        if (that instanceof ClassTypeInfo) {
            return this.isAssignableFrom((ClassTypeInfo)that);
        }
        if (that instanceof ParameterizedTypeInfo) {
            return this.isAssignableFrom(((ParameterizedTypeInfo)that).getRawType());
        }
        if (that instanceof TypeVariableInfo) {
            return this.isAssignableFrom((TypeInfo)((TypeVariableInfo)that).getBounds().get(0));
        }
        return false;
    }

    public boolean isAssignableFrom(ClassTypeInfo that) {
        if (this.className.equals(that.getName())) {
            return true;
        }
        TypeInfo superType = that.getSuperType();
        if (superType != null && this.isAssignableFrom(superType)) {
            return true;
        }
        for (TypeInfo itf : that.getInterfaces()) {
            if (!this.isAssignableFrom(itf)) continue;
            return true;
        }
        return false;
    }

    public T getType() {
        return this.classType;
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        return (A)this.domain.typeModel.getDeclaredAnnotation(this.classType, annotationClass);
    }

    @Override
    public int hashCode() {
        return this.className.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClassTypeInfo) {
            ClassTypeInfo that = (ClassTypeInfo)obj;
            String thatName = that.getName();
            return this.className.equals(thatName);
        }
        return false;
    }

    public String toString() {
        return "ClassTypeInfo[className=" + this.className + "]";
    }
}

