/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.reflext.api.AccessScope;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.MethodSignature;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.core.ReflectedObject;
import org.reflext.core.TypeDomain;
import org.reflext.core.TypeVariableInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodInfoImpl<T, M>
extends ReflectedObject<T, M>
implements MethodInfo {
    private final M method;
    private final String name;
    private TypeInfo returnType;
    private List<TypeInfo> parameterTypes;
    private final AccessScope access;
    private final boolean _abstract;
    private final boolean _final;
    private final boolean _static;
    private final ClassTypeInfo owner;
    private MethodSignature signature;
    private List<TypeVariableInfo> typeParameters;

    public MethodInfoImpl(ClassTypeInfo owner, TypeDomain<T, M> domain, M method) {
        super(domain);
        this.method = method;
        this.name = domain.methodModel.getName(method);
        this.access = domain.methodModel.getAccess(method);
        this._abstract = domain.methodModel.isAbstract(method);
        this._final = domain.methodModel.isFinal(method);
        this._static = domain.methodModel.isStatic(method);
        this.owner = owner;
        this.signature = null;
        this.typeParameters = null;
    }

    public M getMethod() {
        return this.method;
    }

    public TypeInfo getReturnType() {
        if (this.returnType == null) {
            Object rt = this.domain.methodModel.getReturnType(this.method);
            this.returnType = this.domain.getType(rt);
        }
        return this.returnType;
    }

    public List<TypeInfo> getParameterTypes() {
        if (this.parameterTypes == null) {
            ArrayList<TypeInfo> parameterTypes = new ArrayList<TypeInfo>();
            for (Object parameterType : this.domain.methodModel.getParameterTypes(this.method)) {
                parameterTypes.add(this.domain.getType(parameterType));
            }
            this.parameterTypes = parameterTypes;
        }
        return this.parameterTypes;
    }

    public AccessScope getAccess() {
        return this.access;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public boolean isStatic() {
        return this._static;
    }

    public boolean isFinal() {
        return this._final;
    }

    public String getName() {
        return this.name;
    }

    public ClassTypeInfo getOwner() {
        return this.owner;
    }

    public List<TypeVariableInfo> getTypeParameters() {
        if (this.typeParameters == null) {
            ArrayList<TypeVariableInfo> typeParameters = new ArrayList<TypeVariableInfo>();
            for (Object tv : this.domain.methodModel.getTypeParameters(this.method)) {
                TypeVariableInfoImpl typeParameter = (TypeVariableInfoImpl)this.domain._getType(tv);
                typeParameters.add(typeParameter);
            }
            this.typeParameters = typeParameters;
        }
        return this.typeParameters;
    }

    public MethodSignature getSignature() {
        if (this.signature == null) {
            this.signature = new MethodSignature(this.name, this.getParameterTypes());
        }
        return this.signature;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MethodInfo) {
            MethodInfo that = (MethodInfo)obj;
            String thatName = that.getName();
            MethodSignature signature = this.getSignature();
            MethodSignature thatSignature = that.getSignature();
            return this.name.equals(thatName) && signature.equals((Object)thatSignature);
        }
        return false;
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        return (A)this.domain.methodModel.getDeclaredAnnotation(this.method, annotationClass);
    }

    public String toString() {
        return "MethodInfo[name=" + this.name + "]";
    }
}

