/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.core;

import org.reflext.api.TypeInfo;
import org.reflext.api.Visitor;
import org.reflext.api.VisitorStrategy;
import org.reflext.api.relationship.TypeRelationship;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
abstract class AbstractTypeInfo<T, M, A, P, F> extends ReflectedObject<T, M, A, P, F> implements TypeInfo {

  protected AbstractTypeInfo(TypeResolverImpl<T, M, A, P, F> domain) {
    super(domain);
  }

  @Override
  public abstract int hashCode();

  @Override
  public abstract boolean equals(Object obj);

  public final <V extends Visitor<V, S>, S extends VisitorStrategy<V, S>> void accept(S strategy, V visitor) {
    strategy.visit(this, visitor);
  }

  public final boolean isSubType(TypeInfo ti) {
    return TypeRelationship.SUB_TYPE.isSatisfied(this, ti);
  }
}
