/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.util.HashMap;
import java.util.Map;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeResolver;
import org.reflext.core.AbstractTypeInfo;
import org.reflext.core.ArrayTypeInfoImpl;
import org.reflext.core.ClassTypeInfoImpl;
import org.reflext.core.ParameterizedTypeInfoImpl;
import org.reflext.core.SimpleTypeInfoImpl;
import org.reflext.core.TypeVariableInfoImpl;
import org.reflext.core.VoidTypeInfoImpl;
import org.reflext.core.WildcardTypeInfoImpl;
import org.reflext.spi.model.AnnotationModel;
import org.reflext.spi.model.MethodModel;
import org.reflext.spi.model.ReflectionModel;
import org.reflext.spi.model.TypeKind;
import org.reflext.spi.model.TypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeResolverImpl<T, M, A, P>
implements TypeResolver<T> {
    final TypeModel<T> typeModel;
    final MethodModel<T, M> methodModel;
    final AnnotationModel<T, T, A, P> typeAnnotationModel;
    final AnnotationModel<T, M, A, P> methodAnnotationModel;
    final Map<T, TypeInfo> cache;

    public static <T, M, A, P> TypeResolver<T> create(ReflectionModel<T, M, A, P> model) {
        return new TypeResolverImpl<T, M, A, P>(model);
    }

    private TypeResolverImpl(ReflectionModel<T, M, A, P> model) {
        this.typeModel = model.getTypeModel();
        this.methodModel = model.getMethodModel();
        this.typeAnnotationModel = model.getTypeAnnotationModel();
        this.methodAnnotationModel = model.getMethodAnnotationModel();
        this.cache = new HashMap<T, TypeInfo>();
    }

    public TypeInfo resolve(T type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        AbstractTypeInfo<T, M, A, P> cached = this.cache.get(type);
        if (cached == null && (cached = this._getType(type)) != null) {
            this.cache.put(type, cached);
        }
        return this._getType(type);
    }

    AbstractTypeInfo<T, M, A, P> _getType(T type) {
        TypeKind kind = this.typeModel.getKind(type);
        switch (kind) {
            case SIMPLE: {
                return new SimpleTypeInfoImpl(this, type);
            }
            case VOID: {
                return new VoidTypeInfoImpl(this, type);
            }
            case CLASS: {
                return new ClassTypeInfoImpl(this, type);
            }
            case PARAMETERIZED: {
                return new ParameterizedTypeInfoImpl(this, type);
            }
            case VARIABLE: {
                return new TypeVariableInfoImpl(this, type);
            }
            case WILDCARD: {
                return new WildcardTypeInfoImpl(this, type);
            }
            case ARRAY: {
                return new ArrayTypeInfoImpl(this, type);
            }
        }
        throw new AssertionError((Object)("Cannot handle type " + type + " with kind " + kind));
    }
}

